/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.typed.hutool.spi;

import cn.hutool.json.JSON;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import io.r2mo.function.Fn;
import io.r2mo.typed.hutool.spi.JArrayImpl;
import io.r2mo.typed.hutool.spi.JObjectImpl;
import io.r2mo.typed.json.JArray;
import io.r2mo.typed.json.JBase;
import io.r2mo.typed.json.JObject;
import io.r2mo.typed.json.JUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

class JUtilImpl
implements JUtil {
    private static final YAMLMapper MAPPER_YAML = new YAMLMapper();
    private static final JsonMapper MAPPER_JSON = JBase.jackson();
    private static JUtil INSTANCE;

    private JUtilImpl() {
    }

    static JUtil getInstance() {
        if (Objects.isNull(INSTANCE)) {
            INSTANCE = new JUtilImpl();
        }
        return INSTANCE;
    }

    static <T> T boxOut(Object value) {
        if (value instanceof JObject) {
            JObject jsonJ = (JObject)value;
            JSONObject data = (JSONObject)jsonJ.data();
            Objects.requireNonNull(data, "[ R2MO ] \u6839\u636e\u7ea6\u5b9a\uff0c\u5185\u7f6e\u5bf9\u8c61\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
            return (T)data;
        }
        if (value instanceof JArray) {
            JArray jsonA = (JArray)value;
            JSONArray data = (JSONArray)jsonA.data();
            Objects.requireNonNull(data, "[ R2MO ] \u6839\u636e\u7ea6\u5b9a\uff0c\u5185\u7f6e\u6570\u7ec4\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
            return (T)data;
        }
        return (T)value;
    }

    static <T extends JBase> T boxIn(Object value) {
        if (value instanceof JSONObject) {
            JSONObject jsonJ = (JSONObject)value;
            return (T)new JObjectImpl(jsonJ);
        }
        if (value instanceof JSONArray) {
            JSONArray jsonA = (JSONArray)value;
            return (T)new JArrayImpl(jsonA);
        }
        return null;
    }

    public JObject toJObject(Object value) {
        if (value instanceof JSONObject) {
            JSONObject jsonO = (JSONObject)value;
            return new JObjectImpl(jsonO);
        }
        if (value instanceof JObject) {
            JObject jsonO = (JObject)value;
            return jsonO;
        }
        return null;
    }

    public JArray toJArray(Object value) {
        if (value instanceof JSONArray) {
            JSONArray jsonA = (JSONArray)value;
            return new JArrayImpl(jsonA);
        }
        if (value instanceof JArray) {
            JArray jsonA = (JArray)value;
            return jsonA;
        }
        return null;
    }

    public <E> Collection<E> toCollection(Object value) {
        ArrayList list = new ArrayList();
        if (value instanceof JSONArray) {
            JSONArray jsonA = (JSONArray)value;
            jsonA.stream().map(item -> item).forEach(list::add);
        } else if (value instanceof JArray) {
            JArray jsonA = (JArray)value;
            JSONArray jsonArray = (JSONArray)jsonA.data();
            jsonArray.stream().map(item -> item).forEach(list::add);
        }
        return list;
    }

    public String toYaml(JBase json) {
        if (Objects.isNull(json)) {
            return null;
        }
        JSON jsonObject = JSONUtil.parse((Object)json.encode());
        try {
            return MAPPER_YAML.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonObject);
        }
        catch (Exception ex) {
            throw new RuntimeException("[ R2MO ] \u8f6c\u6362YAML\u5b57\u7b26\u4e32\u5931\u8d25\uff01", ex);
        }
    }

    public <T, R extends JBase> R serializeJson(T target) {
        if (Objects.isNull(target)) {
            return null;
        }
        String jsonStr = (String)Fn.jvmOr(() -> MAPPER_JSON.writeValueAsString(target));
        return (R)JBase.parse((String)jsonStr);
    }

    public <T> T deserializeJson(JObject json, Class<T> clazz) {
        if (Objects.isNull(json) || Objects.isNull(clazz)) {
            return null;
        }
        String jsonStr = json.encode();
        return (T)Fn.jvmOr(() -> MAPPER_JSON.readValue(jsonStr, clazz));
    }

    public <T> List<T> deserializeJson(JArray json, Class<T> clazz) {
        if (Objects.isNull(json) || Objects.isNull(clazz)) {
            return List.of();
        }
        String jsonStr = json.encode();
        TypeReference typeRef = new TypeReference<List<T>>(){};
        return (List)Fn.jvmOr(() -> JUtilImpl.lambda$deserializeJson$4(jsonStr, (TypeReference)typeRef));
    }

    public boolean isEmpty(JArray jsonA) {
        if (Objects.isNull(jsonA)) {
            return true;
        }
        return jsonA.isEmpty();
    }

    public boolean isEmpty(JObject jsonJ) {
        if (Objects.isNull(jsonJ)) {
            return true;
        }
        return jsonJ.isEmpty();
    }

    public boolean isJObject(Object value) {
        if (value instanceof JObject) {
            return true;
        }
        return value instanceof JSONObject;
    }

    public boolean isJArray(Object value) {
        if (value instanceof JArray) {
            return true;
        }
        return value instanceof JSONArray;
    }

    public JObject valueJObject(JObject jsonJ, String field) {
        if (Objects.isNull(jsonJ)) {
            return new JObjectImpl();
        }
        JObject value = null;
        if (jsonJ.containsKey(field)) {
            value = jsonJ.getJObject(field);
        }
        if (Objects.isNull(value)) {
            value = new JObjectImpl();
        }
        return value;
    }

    public JArray valueJArray(JObject jsonJ, String field) {
        if (Objects.isNull(jsonJ)) {
            return new JArrayImpl();
        }
        JArray value = null;
        if (jsonJ.containsKey(field)) {
            value = jsonJ.getJArray(field);
        }
        if (Objects.isNull(value)) {
            value = new JArrayImpl();
        }
        return value;
    }

    private static /* synthetic */ List lambda$deserializeJson$4(String jsonStr, TypeReference typeRef) throws Throwable {
        return (List)MAPPER_JSON.readValue(jsonStr, typeRef);
    }
}

