/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.typed.hutool.spi;

import cn.hutool.json.JSONObject;
import io.r2mo.typed.json.JArray;
import io.r2mo.typed.json.JObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

class JObjectImpl
implements JObject {
    private final JSONObject data;

    JObjectImpl() {
        this.data = new JSONObject();
    }

    JObjectImpl(JSONObject data) {
        this.data = data;
    }

    JObjectImpl(String jsonStr) {
        this.data = new JSONObject((Object)jsonStr);
    }

    public int getInt(String key, int defaultValue) {
        return this.data.getInt((Object)key, Integer.valueOf(defaultValue));
    }

    public boolean getBool(String key, boolean defaultValue) {
        return this.data.getBool((Object)key, Boolean.valueOf(defaultValue));
    }

    public JObject getJObject(String key) {
        return (JObject)this.data.getObj((Object)key);
    }

    public JArray getJArray(String key) {
        return (JArray)this.data.getObj((Object)key);
    }

    public JObject put(String key, Object value) {
        this.data.set(key, value);
        return this;
    }

    public boolean containsKey(String key) {
        return this.data.containsKey((Object)key);
    }

    public Map<String, Object> toMap() {
        return new HashMap<String, Object>((Map<String, Object>)this.data);
    }

    public <V> void itKv(BiConsumer<String, V> action) {
        this.data.forEach((k, v) -> action.accept((String)k, (Object)v));
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public String encode() {
        return this.data.toString();
    }

    public String encodePretty() {
        return this.data.toStringPretty();
    }

    public JSONObject data() {
        return this.data;
    }
}

