/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.typed.hutool.spi;

import cn.hutool.json.JSONArray;
import io.r2mo.typed.json.JArray;
import io.r2mo.typed.json.JObject;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;

class JArrayImpl
implements JArray {
    private final JSONArray data;

    JArrayImpl(JSONArray jsonArray) {
        this.data = jsonArray;
    }

    JArrayImpl(String jsonStr) {
        this.data = new JSONArray((Object)jsonStr);
    }

    JArrayImpl() {
        this.data = new JSONArray();
    }

    public Stream<String> itString() {
        return this.data.stream().filter(item -> item instanceof String).map(item -> (String)item);
    }

    public Stream<JObject> itObject() {
        return this.data.stream().filter(item -> item instanceof JObject).map(item -> (JObject)item);
    }

    public <T> JArray addAll(Collection<T> values) {
        this.data.addAll(values);
        return this;
    }

    public <T> JArray add(T value) {
        this.data.add(value);
        return this;
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public String encode() {
        return this.data.toString();
    }

    public String encodePretty() {
        return this.data.toStringPretty();
    }

    public JSONArray data() {
        return this.data;
    }

    public List toList() {
        return this.data.stream().toList();
    }
}

