/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.spring.mybatisplus.handler;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import io.r2mo.dbe.mybatisplus.core.domain.BaseEntity;
import io.r2mo.typed.constant.DefaultConstantValue;
import java.time.LocalDateTime;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import org.apache.ibatis.reflection.MetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectionMetaObjectHandler
implements MetaObjectHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InjectionMetaObjectHandler.class);

    public void insertFill(MetaObject metaObject) {
        try {
            Object object;
            if (ObjectUtil.isNotNull((Object)metaObject) && (object = metaObject.getOriginalObject()) instanceof BaseEntity) {
                BaseEntity baseEntity = (BaseEntity)object;
                this.setCreated(baseEntity);
                this.setUpdated(baseEntity);
                this.setId(baseEntity);
                this.setCode(baseEntity);
            } else {
                LocalDateTime date = LocalDateTime.now();
                this.strictInsertFill(metaObject, "createdAt", LocalDateTime.class, date);
                this.strictInsertFill(metaObject, "updatedAt", LocalDateTime.class, date);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void setCode(BaseEntity baseEntity) {
        String code = baseEntity.getCode();
        if (StrUtil.isBlank((CharSequence)code)) {
            String generated = RandomUtil.randomString((int)16).toUpperCase(Locale.getDefault());
            baseEntity.setCode(generated);
        }
    }

    private void setId(BaseEntity baseEntity) {
        UUID id = baseEntity.getId();
        if (Objects.isNull(id)) {
            baseEntity.setId(UUID.randomUUID());
        }
    }

    private void setCreated(BaseEntity baseEntity) {
        LocalDateTime current = ObjectUtil.isNotNull((Object)baseEntity.getCreatedAt()) ? baseEntity.getCreatedAt() : LocalDateTime.now();
        baseEntity.setCreatedAt(current);
        if (Objects.isNull(baseEntity.getCreatedBy())) {
            UUID userId = this.getUserId();
            userId = Objects.isNull(userId) ? DefaultConstantValue.BY_SYSTEM : userId;
            baseEntity.setCreatedBy(userId);
        }
    }

    private void setUpdated(BaseEntity baseEntity) {
        baseEntity.setUpdatedAt(LocalDateTime.now());
        UUID userId = this.getUserId();
        userId = Objects.isNull(userId) ? DefaultConstantValue.BY_SYSTEM : userId;
        baseEntity.setUpdatedBy(userId);
    }

    public void updateFill(MetaObject metaObject) {
        try {
            Object object;
            if (ObjectUtil.isNotNull((Object)metaObject) && (object = metaObject.getOriginalObject()) instanceof BaseEntity) {
                BaseEntity baseEntity = (BaseEntity)object;
                this.setUpdated(baseEntity);
            } else {
                this.strictUpdateFill(metaObject, "updatedAt", LocalDateTime.class, LocalDateTime.now());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private UUID getUserId() {
        return null;
    }
}

