/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.spring.mybatisplus.config;

import cn.hutool.extra.spring.SpringUtil;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.OptimisticLockerInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.TenantLineInnerInterceptor;
import io.r2mo.spring.common.config.PropertySourceYmlFactory;
import io.r2mo.spring.mybatisplus.handler.InjectionMetaObjectHandler;
import javax.sql.DataSource;
import lombok.Generated;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.PropertySource;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@AutoConfiguration
@EnableTransactionManagement(proxyTargetClass=true)
@MapperScan(value={"${mybatis-plus.mapperPackage}"})
@PropertySource(value={"classpath:common-mybatis-plus.yml"}, factory=PropertySourceYmlFactory.class)
public class MybatisPlusConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MybatisPlusConfiguration.class);
    private final DataSource dataSource;

    public MybatisPlusConfiguration(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Bean
    public MybatisPlusInterceptor mybatisPlusInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        try {
            TenantLineInnerInterceptor tenant = (TenantLineInnerInterceptor)SpringUtil.getBean(TenantLineInnerInterceptor.class);
            interceptor.addInnerInterceptor((InnerInterceptor)tenant);
        }
        catch (BeansException tenant) {
            // empty catch block
        }
        PaginationInnerInterceptor paginationInnerInterceptor = new PaginationInnerInterceptor();
        paginationInnerInterceptor.setOverflow(true);
        interceptor.addInnerInterceptor((InnerInterceptor)paginationInnerInterceptor);
        OptimisticLockerInnerInterceptor lockerInnerInterceptor = new OptimisticLockerInnerInterceptor();
        interceptor.addInnerInterceptor((InnerInterceptor)lockerInnerInterceptor);
        log.info("[ R2MO ] Config / Mybatis-Plus Interceptor \u914d\u7f6e\u5b8c\u6210\uff01");
        return interceptor;
    }

    @Bean
    public MetaObjectHandler metaObjectHandler() {
        return new InjectionMetaObjectHandler();
    }
}

