/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.spring.junit5;

import io.r2mo.io.common.HFS;
import io.r2mo.spi.SPI;
import io.r2mo.typed.json.JArray;
import io.r2mo.typed.json.JObject;
import io.r2mo.typed.json.JUtil;
import java.net.URL;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AppIoTestSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppIoTestSupport.class);
    protected static JUtil UT = SPI.V_UTIL;

    protected HFS fs() {
        return HFS.of();
    }

    protected <T> T inOne(String filename, Class<T> clazz) {
        JObject mappedEntity = (JObject)this.fs().inJson(filename);
        log.info("[ R2MOMO ] ( One ) \u8bfb\u53d6\u6d4b\u8bd5\u6570\u636e\uff1a{} -> {}", (Object)filename, (Object)mappedEntity.encodePretty());
        return (T)UT.deserializeJson(mappedEntity, clazz);
    }

    protected <T> List<T> inMany(String filename, Class<T> clazz) {
        JArray mappedEntity = (JArray)this.fs().inJson(filename);
        return UT.deserializeJson(mappedEntity, clazz);
    }

    protected JObject inJObject(String filename) {
        return (JObject)this.fs().inJson(filename);
    }

    protected JArray inJArray(String filename) {
        return (JArray)this.fs().inJson(filename);
    }

    protected <T> T inOne(String filename, Class<T> clazz, ClassLoader loader) {
        URL url = loader.getResource(filename);
        JObject mappedEntity = (JObject)this.fs().inJson(url);
        return (T)UT.deserializeJson(mappedEntity, clazz);
    }

    protected <T> T inCPOne(String filename, Class<T> clazz) {
        return this.inOne(filename, clazz, Thread.currentThread().getContextClassLoader());
    }

    protected <T> List<T> inMany(String filename, Class<T> clazz, ClassLoader loader) {
        URL url = loader.getResource(filename);
        JArray mappedEntity = (JArray)this.fs().inJson(url);
        return UT.deserializeJson(mappedEntity, clazz);
    }

    protected <T> List<T> inCPMany(String filename, Class<T> clazz) {
        return this.inMany(filename, clazz, Thread.currentThread().getContextClassLoader());
    }

    protected JObject inJObject(String filename, ClassLoader loader) {
        URL url = loader.getResource(filename);
        return (JObject)this.fs().inJson(url);
    }

    protected JObject inCPJObject(String filename) {
        return this.inJObject(filename, Thread.currentThread().getContextClassLoader());
    }

    protected JArray inJArray(String filename, ClassLoader loader) {
        URL url = loader.getResource(filename);
        return (JArray)this.fs().inJson(url);
    }

    protected JArray inCPJArray(String filename) {
        return this.inJArray(filename, Thread.currentThread().getContextClassLoader());
    }
}

