/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.spring.junit5;

import com.github.yulichang.base.MPJBaseMapper;
import io.r2mo.SourceReflect;
import io.r2mo.base.dbe.Join;
import io.r2mo.dbe.mybatisplus.DBE;
import io.r2mo.dbe.mybatisplus.DBJ;
import io.r2mo.dbe.mybatisplus.JoinProxy;
import io.r2mo.function.Actuator;
import io.r2mo.function.Fn;
import io.r2mo.spring.junit5.AppIoTestSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import javax.sql.DataSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StreamUtils;

@SpringBootTest
@Transactional
@Component
public abstract class AppBaseTestSupport<T>
extends AppIoTestSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppBaseTestSupport.class);
    private static boolean RUN_ONCE = true;
    private final Class<T> entityCls = SourceReflect.classT0(this.getClass());
    @Autowired
    private MPJBaseMapper<T> mapper;
    @Autowired
    private ResourceLoader loader;
    @Autowired
    private DataSource dataSource;

    public void executeString(String sql) {
        try (Connection conn = this.dataSource.getConnection();
             Statement stmt = conn.createStatement();){
            String[] sqlStatements;
            for (String statement : sqlStatements = sql.split(";")) {
                String trimmedStatement = statement.trim();
                if (trimmedStatement.isEmpty()) continue;
                stmt.execute(trimmedStatement);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("[ R2MO Test ] \u6267\u884cSQL\u6587\u4ef6\u5931\u8d25: " + sql, e);
        }
    }

    protected DBE<T> db() {
        return DBE.of(this.entityCls, this.mapper);
    }

    protected DBJ<T> db(Join meta) {
        return DBJ.of((Join)meta, this.executor());
    }

    protected MPJBaseMapper<T> mapper() {
        return this.mapper;
    }

    protected JoinProxy<T> executor() {
        return new JoinProxy(this.mapper);
    }

    protected void executeFile(String file) {
        try {
            Path path = Paths.get(file, new String[0]);
            File currentPath = path.toFile();
            if (Files.exists(path, new LinkOption[0])) {
                log.info("[ R2MOMO ] \u6b63\u5728\u4ece\u5f53\u524d\u8def\u5f84\u52a0\u8f7d\u6587\u4ef6: {}", (Object)file);
                String sql = StreamUtils.copyToString((InputStream)new FileInputStream(currentPath), (Charset)StandardCharsets.UTF_8);
                this.executeString(sql);
                return;
            }
            log.info("[ R2MOMO ] \u5f53\u524d\u8def\u5f84\u672a\u627e\u5230\u6587\u4ef6, \u5c1d\u8bd5\u4ece\u8d44\u6e90\u8def\u5f84\u52a0\u8f7d: {}", (Object)file);
            Resource resource = this.loader.getResource(file);
            if (!resource.exists() || !resource.isReadable()) {
                throw new IOException("[ R2MO ] \u6587\u4ef6\u5728\u5f53\u524d\u8def\u5f84\u548c\u8d44\u6e90\u8def\u5f84\u4e2d\u5747\u672a\u627e\u5230: " + file);
            }
            String sql = StreamUtils.copyToString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
            this.executeString(sql);
        }
        catch (IOException e) {
            throw new RuntimeException("[ R2MO ] \u6267\u884cSQL\u6587\u4ef6\u5931\u8d25: " + file, e);
        }
    }

    protected void executeFiles(String ... files) {
        Arrays.stream(files).forEach(this::executeFile);
    }

    protected void runOnce(Actuator actuator) {
        if (RUN_ONCE) {
            Fn.jvmAt((Actuator)actuator);
            RUN_ONCE = false;
        }
    }
}

