/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.io.local;

import io.r2mo.io.common.AbstractHStore;
import io.r2mo.io.local.LocalCompare;
import io.r2mo.io.local.LocalIs;
import io.r2mo.io.local.LocalReader;
import io.r2mo.io.local.LocalWriter;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public class HStoreLocal
extends AbstractHStore {
    public boolean cp(String source, String target) {
        return LocalWriter.copy(source, target);
    }

    public boolean rm(String filename) {
        return LocalWriter.rm(filename);
    }

    public boolean rm(Set<String> filenameSet) {
        if (filenameSet == null || filenameSet.isEmpty()) {
            return true;
        }
        return filenameSet.parallelStream().allMatch(LocalWriter::rm);
    }

    public boolean write(String filename, String content, boolean append) {
        return LocalWriter.write(filename, content, append);
    }

    public boolean isExist(String path) {
        return LocalIs.isExist(path);
    }

    public boolean isDirectory(String path) {
        return LocalIs.isDirectory(path);
    }

    public boolean isFile(String path) {
        return LocalIs.isFile(path);
    }

    public boolean isEmpty(String path) {
        return LocalIs.isEmpty(path);
    }

    public boolean isSame(String path1, String path2) {
        return LocalCompare.isSame(path1, path2);
    }

    public boolean mkdir(String dir) {
        return LocalWriter.mkdir(dir);
    }

    public boolean mv(String from, String to) {
        return LocalWriter.move(from, to);
    }

    public boolean mv(ConcurrentMap<String, String> vectorMap) {
        if (vectorMap == null || vectorMap.isEmpty()) {
            return true;
        }
        return vectorMap.entrySet().parallelStream().allMatch(entry -> LocalWriter.move((String)entry.getKey(), (String)entry.getValue()));
    }

    public boolean mkdir(Set<String> dirs) {
        if (dirs == null || dirs.isEmpty()) {
            return true;
        }
        return dirs.parallelStream().allMatch(LocalWriter::mkdir);
    }

    public InputStream inStream(File file) {
        return this.inStream(this.toURL(file));
    }

    public InputStream inStream(Path path) {
        return this.inStream(this.toURL(path));
    }

    public URL toURL(String filename) {
        if (null == filename || filename.isBlank()) {
            return null;
        }
        Path path = Path.of(filename, new String[0]);
        return this.toURL(path);
    }

    public List<String> lsFiles(String filename, String keyword) {
        return LocalReader.lsFiles(filename, keyword);
    }

    public List<String> lsFilesN(String filename, String keyword) {
        return LocalReader.lsFilesN(filename, keyword);
    }

    public List<String> lsDirs(String filename) {
        return LocalReader.lsDirs(filename);
    }

    public List<String> lsDirsN(String filename) {
        return LocalReader.lsDirsN(filename);
    }
}

