/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.io.local;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalReader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalReader.class);

    LocalReader() {
    }

    public static List<String> lsFiles(String dirPath, String keyword) {
        List<String> list;
        block9: {
            Path path = Paths.get(dirPath, new String[0]);
            if (!Files.isDirectory(path, new LinkOption[0])) {
                throw new IllegalArgumentException("[R2MO] \u63d0\u4f9b\u7684\u8def\u5f84\u4e0d\u662f\u4e00\u4e2a\u76ee\u5f55\uff1a" + dirPath);
            }
            DirectoryStream<Path> stream = Files.newDirectoryStream(path);
            try {
                list = StreamSupport.stream(stream.spliterator(), false).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::getFileName).map(Path::toString).filter(name -> keyword == null || name.contains(keyword)).collect(Collectors.toList());
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.error("[R2MO] \u5217\u51fa\u76ee\u5f55\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef\uff1a" + dirPath, (Throwable)e);
                    return new ArrayList<String>();
                }
            }
            stream.close();
        }
        return list;
    }

    public static List<String> lsFilesN(String dirPath, final String keyword) {
        Path path = Paths.get(dirPath, new String[0]);
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalArgumentException("[R2MO] \u63d0\u4f9b\u7684\u8def\u5f84\u4e0d\u662f\u4e00\u4e2a\u76ee\u5f55\uff1a" + dirPath);
        }
        final ArrayList<String> files = new ArrayList<String>();
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    String fileName = file.getFileName().toString();
                    if (keyword == null || fileName.contains(keyword)) {
                        files.add(file.toString());
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            log.error("[R2MO] \u904d\u5386\u76ee\u5f55\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef\uff1a" + dirPath, (Throwable)e);
        }
        return files;
    }

    public static List<String> lsDirs(String dirPath) {
        List<String> list;
        block9: {
            Path path = Paths.get(dirPath, new String[0]);
            if (!Files.isDirectory(path, new LinkOption[0])) {
                throw new IllegalArgumentException("[R2MO] \u63d0\u4f9b\u7684\u8def\u5f84\u4e0d\u662f\u4e00\u4e2a\u76ee\u5f55\uff1a" + dirPath);
            }
            DirectoryStream<Path> stream = Files.newDirectoryStream(path);
            try {
                list = StreamSupport.stream(stream.spliterator(), false).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(Path::getFileName).map(Path::toString).collect(Collectors.toList());
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.error("[R2MO] \u5217\u51fa\u5b50\u76ee\u5f55\u65f6\u53d1\u751f\u9519\u8bef\uff1a" + dirPath, (Throwable)e);
                    return new ArrayList<String>();
                }
            }
            stream.close();
        }
        return list;
    }

    public static List<String> lsDirsN(String dirPath) {
        final Path path = Paths.get(dirPath, new String[0]);
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalArgumentException("[R2MO] \u63d0\u4f9b\u7684\u8def\u5f84\u4e0d\u662f\u4e00\u4e2a\u76ee\u5f55\uff1a" + dirPath);
        }
        final ArrayList<String> dirs = new ArrayList<String>();
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path dir, BasicFileAttributes attrs) {
                    if (!path.equals(dir)) {
                        dirs.add(dir.toString());
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            log.error("[R2MO] \u904d\u5386\u5b50\u76ee\u5f55\u65f6\u53d1\u751f\u9519\u8bef\uff1a" + dirPath, (Throwable)e);
        }
        return dirs;
    }
}

