/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.io.local.transfer;

import io.r2mo.base.io.modeling.StoreChunk;
import io.r2mo.base.io.transfer.TransferRequest;
import io.r2mo.base.io.transfer.TransferResult;
import io.r2mo.base.io.transfer.TransferType;
import io.r2mo.io.common.RFS;
import io.r2mo.io.enums.TransferStatus;
import io.r2mo.io.local.transfer.ChunkSession;
import io.r2mo.io.modeling.TransferProgress;
import io.r2mo.typed.domain.extension.AbstractStoreObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkUploader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChunkUploader.class);
    private final RFS rfs;
    private final ExecutorService executorService;
    private final List<ChunkSession> activeSessions = new ArrayList<ChunkSession>();

    public ChunkUploader(RFS rfs, int threadPoolSize) {
        this.rfs = rfs;
        this.executorService = Executors.newFixedThreadPool(threadPoolSize);
    }

    public ChunkSession createUploadSession(UUID nodeId, String token) {
        ChunkSession session = new ChunkSession(nodeId, token);
        this.activeSessions.add(session);
        return session;
    }

    private TransferResult uploadChunk(ChunkSession session, InputStream chunkStream, int index) {
        TransferRequest request = this.createRequest(session, TransferType.UPLOAD);
        return this.rfs.ioUploadChunk(request, chunkStream, index);
    }

    public void startUpload(ChunkSession session, InputStream chunkStream, int index) {
        TransferResult transferResult = this.uploadChunk(session, chunkStream, index);
        this.activeSessions.remove(session);
    }

    public TransferProgress getUploadProgress(String token, ChunkSession session) {
        try {
            List uploadedChunks = this.rfs.getUploadedChunks(token);
            List allChunks = this.rfs.getAllChunks(token);
            int uploadedCount = uploadedChunks.size();
            int totalCount = allChunks.size();
            double progress = totalCount > 0 ? (double)uploadedCount * 100.0 / (double)totalCount : 0.0;
            long uploadedSize = uploadedChunks.stream().mapToLong(AbstractStoreObject::getSize).sum();
            long totalSize = ((StoreChunk)allChunks.get(0)).getTotalSize();
            return new TransferProgress(token, session.getSessionId(), Long.valueOf(uploadedSize), Long.valueOf(totalSize), Double.valueOf(progress), Boolean.valueOf(true), TransferStatus.TRANSFERRING, TransferType.UPLOAD, null, null, null, null);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4e0a\u4f20\u8fdb\u5ea6\u5931\u8d25: {}", (Object)token, (Object)e);
            return new TransferProgress(token, session.getSessionId(), null, null, null, Boolean.valueOf(true), null, TransferType.UPLOAD, null, null, e.getMessage(), e.getMessage());
        }
    }

    public boolean cancelUpload(String token) {
        try {
            boolean success;
            TransferResult result = this.rfs.cancelUpload(token);
            boolean bl = success = result == TransferResult.SUCCESS;
            if (success) {
                this.activeSessions.removeIf(session -> session.getToken().equals(token));
                log.info("\u4e0a\u4f20\u5df2\u53d6\u6d88: {}", (Object)token);
            }
            return success;
        }
        catch (Exception e) {
            log.error("\u53d6\u6d88\u4e0a\u4f20\u5931\u8d25: {}", (Object)token, (Object)e);
            return false;
        }
    }

    private TransferRequest createRequest(ChunkSession session, TransferType type) {
        TransferRequest request = new TransferRequest();
        request.setNodeId(session.getSessionId());
        request.setIsMultipart(Boolean.valueOf(true));
        request.setToken(session.getToken());
        request.setType(type);
        return request;
    }

    public void shutdown() {
        this.executorService.shutdown();
        log.info("\u5206\u7247\u4e0a\u4f20\u5668\u5df2\u5173\u95ed");
    }

    public void complete(String token) {
        TransferResult transferResult = this.rfs.completeUpload(token);
        log.info("[R2MO] complete transfer: {}", (Object)transferResult);
    }

    private ChunkSession findSessionByToken(String token) {
        return this.activeSessions.stream().filter(session -> session.getToken().equals(token)).findFirst().orElse(null);
    }
}

