/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.io.local.transfer;

import io.r2mo.function.Fn;
import io.r2mo.typed.common.Binary;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HexFormat;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChecksumUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChecksumUtil.class);

    public static String calculateChecksum(Binary chunkData) {
        return ChecksumUtil.calculateChecksum(chunkData, HashAlgorithm.SHA256);
    }

    public static String calculateChecksum(Binary chunkData, HashAlgorithm algorithm) {
        if (chunkData == null || chunkData.length() == 0L) {
            log.warn("[ R2MO ] \u8ba1\u7b97\u54c8\u5e0c\u6821\u9a8c\u548c\u5931\u8d25\uff1a\u6570\u636e\u4e3a\u7a7a");
            return "";
        }
        return (String)Fn.jvmOr(() -> {
            try {
                MessageDigest digest = MessageDigest.getInstance(algorithm.getAlgorithmName());
                digest.update(chunkData.stream().readAllBytes());
                byte[] hashBytes = digest.digest();
                return ChecksumUtil.bytesToHex(hashBytes);
            }
            catch (NoSuchAlgorithmException e) {
                log.error("[ R2MO ] \u4e0d\u652f\u6301\u7684\u54c8\u5e0c\u7b97\u6cd5: {}", (Object)algorithm.getAlgorithmName(), (Object)e);
                return "";
            }
        }, (Object)"");
    }

    public static String calculateChecksum(byte[] data, HashAlgorithm algorithm) {
        if (data == null || data.length == 0) {
            log.warn("[ R2MO ] \u8ba1\u7b97\u54c8\u5e0c\u6821\u9a8c\u548c\u5931\u8d25\uff1a\u6570\u636e\u4e3a\u7a7a");
            return "";
        }
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm.getAlgorithmName());
            digest.update(data);
            byte[] hashBytes = digest.digest();
            return ChecksumUtil.bytesToHex(hashBytes);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[ R2MO ] \u4e0d\u652f\u6301\u7684\u54c8\u5e0c\u7b97\u6cd5: {}", (Object)algorithm.getAlgorithmName(), (Object)e);
            return "";
        }
        catch (Exception e) {
            log.error("[ R2MO ] \u8ba1\u7b97\u54c8\u5e0c\u6821\u9a8c\u548c\u5931\u8d25", (Throwable)e);
            return "";
        }
    }

    public static String calculateChecksum(InputStream inputStream, HashAlgorithm algorithm) {
        if (inputStream == null) {
            log.warn("[ R2MO ] \u8ba1\u7b97\u54c8\u5e0c\u6821\u9a8c\u548c\u5931\u8d25\uff1a\u8f93\u5165\u6d41\u4e3a\u7a7a");
            return "";
        }
        try {
            int bytesRead;
            MessageDigest digest = MessageDigest.getInstance(algorithm.getAlgorithmName());
            byte[] buffer = new byte[8192];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                digest.update(buffer, 0, bytesRead);
            }
            byte[] hashBytes = digest.digest();
            return ChecksumUtil.bytesToHex(hashBytes);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[ R2MO ] \u4e0d\u652f\u6301\u7684\u54c8\u5e0c\u7b97\u6cd5: {}", (Object)algorithm.getAlgorithmName(), (Object)e);
            return "";
        }
        catch (Exception e) {
            log.error("[ R2MO ] \u8ba1\u7b97\u6d41\u6570\u636e\u54c8\u5e0c\u6821\u9a8c\u548c\u5931\u8d25", (Throwable)e);
            return "";
        }
    }

    public static boolean verifyChecksum(Binary chunkData, String expectedHash, HashAlgorithm algorithm) {
        if (chunkData == null || expectedHash == null || expectedHash.isEmpty()) {
            return false;
        }
        String actualHash = ChecksumUtil.calculateChecksum(chunkData, algorithm);
        return actualHash.equalsIgnoreCase(expectedHash.trim());
    }

    public static boolean verifyChecksum(byte[] data, String expectedHash, HashAlgorithm algorithm) {
        if (data == null || expectedHash == null || expectedHash.isEmpty()) {
            return false;
        }
        String actualHash = ChecksumUtil.calculateChecksum(data, algorithm);
        return actualHash.equalsIgnoreCase(expectedHash.trim());
    }

    public static boolean verifyChecksum(InputStream inputStream, String expectedHash, HashAlgorithm algorithm) {
        if (inputStream == null || expectedHash == null || expectedHash.isEmpty()) {
            return false;
        }
        String actualHash = ChecksumUtil.calculateChecksum(inputStream, algorithm);
        return actualHash.equalsIgnoreCase(expectedHash.trim());
    }

    private static String bytesToHex(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        try {
            return HexFormat.of().formatHex(bytes);
        }
        catch (Exception | NoClassDefFoundError e) {
            return ChecksumUtil.bytesToHexLegacy(bytes);
        }
    }

    private static String bytesToHexLegacy(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        StringBuilder hexString = new StringBuilder(2 * bytes.length);
        for (byte b : bytes) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    public static String[] getSupportedAlgorithms() {
        HashAlgorithm[] algorithms = HashAlgorithm.values();
        String[] names = new String[algorithms.length];
        for (int i = 0; i < algorithms.length; ++i) {
            names[i] = algorithms[i].getAlgorithmName();
        }
        return names;
    }

    public static boolean isAlgorithmSupported(String algorithmName) {
        if (algorithmName == null || algorithmName.isEmpty()) {
            return false;
        }
        try {
            MessageDigest.getInstance(algorithmName);
            return true;
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
    }

    public static enum HashAlgorithm {
        MD5("MD5"),
        SHA1("SHA-1"),
        SHA256("SHA-256"),
        SHA512("SHA-512"),
        SHA3_256("SHA3-256"),
        SHA3_512("SHA3-512");

        private final String algorithmName;

        private HashAlgorithm(String algorithmName) {
            this.algorithmName = algorithmName;
        }

        public String getAlgorithmName() {
            return this.algorithmName;
        }
    }
}

