/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.io.local.service;

import io.r2mo.base.io.transfer.TransferRequest;
import io.r2mo.base.io.transfer.token.TransferToken;
import io.r2mo.base.io.transfer.token.TransferTokenPool;
import io.r2mo.base.io.transfer.token.TransferTokenService;
import io.r2mo.io.component.node.StoreInit;
import io.r2mo.spi.SPI;
import io.r2mo.typed.json.JObject;
import io.r2mo.typed.json.JUtil;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalTokenService
implements TransferTokenService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalTokenService.class);
    protected static final JUtil UT = SPI.V_UTIL;
    protected final TransferTokenPool cache;

    public LocalTokenService(TransferTokenPool cache) {
        this.cache = cache;
    }

    public TransferToken runValidate(String token) {
        try {
            if (token == null || token.isEmpty()) {
                log.warn("[ R2MO ] \u9a8c\u8bc1\u4ee4\u724c\u5931\u8d25\uff1a\u4ee4\u724c\u4e3a\u7a7a");
                return null;
            }
            TransferToken transferToken = this.cache.findBy(token);
            if (transferToken == null) {
                log.warn("[ R2MO ] \u9a8c\u8bc1\u4ee4\u724c\u5931\u8d25\uff1a\u4ee4\u724c\u4e0d\u5b58\u5728\u6216\u5df2\u8fc7\u671f: {}", (Object)token);
                return null;
            }
            log.debug("[ R2MO ] \u4ee4\u724c\u9a8c\u8bc1\u6210\u529f: tokenId={}", (Object)token);
            return transferToken;
        }
        catch (Exception e) {
            log.error("[ R2MO ] \u9a8c\u8bc1\u4ee4\u724c\u65f6\u53d1\u751f\u9519\u8bef: tokenId={}", (Object)token, (Object)e);
            return null;
        }
    }

    public TransferToken getToken(String token) {
        try {
            if (token == null || token.isEmpty()) {
                log.warn("[ R2MO ] \u83b7\u53d6\u4ee4\u724c\u5931\u8d25\uff1a\u4ee4\u724c\u4e3a\u7a7a");
                return null;
            }
            TransferToken transferToken = this.cache.findBy(token);
            if (transferToken == null) {
                log.warn("[ R2MO ] \u83b7\u53d6\u4ee4\u724c\u5931\u8d25\uff1a\u4ee4\u724c\u4e0d\u5b58\u5728: {}", (Object)token);
                return null;
            }
            log.debug("[ R2MO ] \u83b7\u53d6\u4ee4\u724c\u6210\u529f: tokenId={}", (Object)token);
            return transferToken;
        }
        catch (Exception e) {
            log.error("[ R2MO ] \u83b7\u53d6\u4ee4\u724c\u65f6\u53d1\u751f\u9519\u8bef: tokenId={}", (Object)token, (Object)e);
            return null;
        }
    }

    public boolean runRevoke(String token) {
        try {
            if (token == null || token.isEmpty()) {
                log.warn("[ R2MO ] \u64a4\u9500\u4ee4\u724c\u5931\u8d25\uff1a\u4ee4\u724c\u4e3a\u7a7a");
                return false;
            }
            boolean result = this.cache.runDelete(token);
            if (result) {
                log.info("[ R2MO ] \u64a4\u9500\u4ee4\u724c\u6210\u529f: tokenId={}", (Object)token);
            } else {
                log.warn("[ R2MO ] \u64a4\u9500\u4ee4\u724c\u5931\u8d25\uff1a\u4ee4\u724c\u4e0d\u5b58\u5728: tokenId={}", (Object)token);
            }
            return result;
        }
        catch (Exception e) {
            log.error("[ R2MO ] \u64a4\u9500\u4ee4\u724c\u65f6\u53d1\u751f\u9519\u8bef: tokenId={}", (Object)token, (Object)e);
            return false;
        }
    }

    public boolean runExtend(String token, long expireSeconds) {
        try {
            if (token == null || token.isEmpty()) {
                log.warn("[ R2MO ] \u5ef6\u957f\u4ee4\u724c\u5931\u8d25\uff1a\u4ee4\u724c\u4e3a\u7a7a");
                return false;
            }
            long newExpireTime = System.currentTimeMillis() + expireSeconds * 1000L;
            boolean result = this.cache.runExtend(token, newExpireTime);
            if (result) {
                log.info("[ R2MO ] \u5ef6\u957f\u4ee4\u724c\u6210\u529f: tokenId={}, newExpireTime={}", (Object)token, (Object)newExpireTime);
            } else {
                log.warn("[ R2MO ] \u5ef6\u957f\u4ee4\u724c\u5931\u8d25\uff1a\u4ee4\u724c\u4e0d\u5b58\u5728\u6216\u64cd\u4f5c\u5931\u8d25: tokenId={}", (Object)token);
            }
            return result;
        }
        catch (Exception e) {
            log.error("[ R2MO ] \u5ef6\u957f\u4ee4\u724c\u65f6\u53d1\u751f\u9519\u8bef: tokenId={}", (Object)token, (Object)e);
            return false;
        }
    }

    public TransferToken initialize(TransferRequest request) {
        try {
            long expireTime;
            if (request == null) {
                log.error("[ R2MO ] \u521d\u59cb\u5316\u4ee4\u724c\u5931\u8d25\uff1a\u8bf7\u6c42\u4e3a\u7a7a");
                return null;
            }
            if (Objects.isNull(request.getNodeId())) {
                log.error("[ R2MO ] \u521d\u59cb\u5316\u4ee4\u724c\u5931\u8d25\uff1a\u8282\u70b9ID\u4e3a\u7a7a");
                return null;
            }
            TransferToken transferToken = (TransferToken)StoreInit.ofToken().input(request);
            boolean saved = this.cache.runSave(transferToken, expireTime = System.currentTimeMillis() + 3600000L);
            if (saved) {
                log.info("[ R2MO ] \u521d\u59cb\u5316\u4ee4\u724c\u6210\u529f: tokenId={}, type={}", (Object)transferToken.getToken(), (Object)request.getType());
                return transferToken;
            }
            log.error("[ R2MO ] \u521d\u59cb\u5316\u4ee4\u724c\u5931\u8d25\uff1a\u4fdd\u5b58\u5230\u7f13\u5b58\u5931\u8d25");
            return null;
        }
        catch (Exception e) {
            log.error("[ R2MO ] \u521d\u59cb\u5316\u4ee4\u724c\u65f6\u53d1\u751f\u9519\u8bef: request={}", (Object)request, (Object)e);
            return null;
        }
    }

    public List<JObject> data(String token) {
        try {
            if (token == null || token.isEmpty()) {
                log.warn("[ R2MO ] \u83b7\u53d6\u4ee4\u724c\u6570\u636e\u5931\u8d25\uff1a\u4ee4\u724c\u4e3a\u7a7a");
                return List.of();
            }
            TransferToken transferToken = this.cache.findBy(token);
            if (transferToken == null) {
                log.warn("[ R2MO ] \u83b7\u53d6\u4ee4\u724c\u6570\u636e\u5931\u8d25\uff1a\u4ee4\u724c\u4e0d\u5b58\u5728: {}", (Object)token);
                return List.of();
            }
            JObject tokenData = (JObject)UT.serializeJson((Object)transferToken);
            log.debug("[ R2MO ] \u83b7\u53d6\u4ee4\u724c\u6570\u636e\u6210\u529f: tokenId={}", (Object)token);
            return List.of(tokenData);
        }
        catch (Exception e) {
            log.error("[ R2MO ] \u83b7\u53d6\u4ee4\u724c\u6570\u636e\u65f6\u53d1\u751f\u9519\u8bef: tokenId={}", (Object)token, (Object)e);
            return List.of();
        }
    }

    public List<JObject> data(UUID id) {
        try {
            if (id == null) {
                log.warn("[ R2MO ] \u83b7\u53d6\u8282\u70b9\u6570\u636e\u5931\u8d25\uff1aID\u4e3a\u7a7a");
                return List.of();
            }
            log.debug("[ R2MO ] \u83b7\u53d6\u8282\u70b9\u6570\u636e: nodeId={}", (Object)id);
            return List.of();
        }
        catch (Exception e) {
            log.error("[ R2MO ] \u83b7\u53d6\u8282\u70b9\u6570\u636e\u65f6\u53d1\u751f\u9519\u8bef: nodeId={}", (Object)id, (Object)e);
            return List.of();
        }
    }
}

