/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.io.local.service;

import io.r2mo.base.io.transfer.token.TransferToken;
import io.r2mo.base.io.transfer.token.TransferTokenPool;
import io.r2mo.spi.SPI;
import io.r2mo.typed.json.JObject;
import io.r2mo.typed.json.JUtil;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalTokenPool
implements TransferTokenPool {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalTokenPool.class);
    private static final JUtil UT = SPI.V_UTIL;
    private static final Map<String, TransferToken> TOKEN_STORE = new ConcurrentHashMap<String, TransferToken>(1024);

    public boolean runSave(TransferToken token, long expiredAt) {
        try {
            TOKEN_STORE.put(token.getToken(), token);
            return true;
        }
        catch (Exception e) {
            log.error("[ R2MO ] \u4fdd\u5b58\u4ee4\u724c\u5931\u8d25: tokenId={}", (Object)token.getToken(), (Object)e);
            return false;
        }
    }

    public boolean runExtend(String token, long expiredAt) {
        try {
            TransferToken storedToken = TOKEN_STORE.get(token);
            if (storedToken == null) {
                return false;
            }
            try {
                storedToken.setExpiredAt(LocalDateTime.now().plusSeconds((expiredAt - System.currentTimeMillis()) / 1000L));
                return true;
            }
            catch (UnsupportedOperationException e) {
                JObject json = (JObject)UT.serializeJson((Object)storedToken);
                TransferToken newToken = (TransferToken)UT.deserializeJson(json, TransferToken.class);
                newToken.setExpiredAt(LocalDateTime.now().plusSeconds((expiredAt - System.currentTimeMillis()) / 1000L));
                TOKEN_STORE.put(token, newToken);
                return true;
            }
        }
        catch (Exception e) {
            log.error("[ R2MO ] \u5ef6\u957f\u4ee4\u724c\u8fc7\u671f\u65f6\u95f4\u5931\u8d25: tokenId={}", (Object)token, (Object)e);
            return false;
        }
    }

    public boolean runDelete(String token) {
        try {
            return TOKEN_STORE.remove(token) != null;
        }
        catch (Exception e) {
            log.error("[ R2MO ] \u5220\u9664\u4ee4\u724c\u5931\u8d25: tokenId={}", (Object)token, (Object)e);
            return false;
        }
    }

    public TransferToken findBy(String token) {
        try {
            TransferToken storedToken = TOKEN_STORE.get(token);
            if (storedToken == null) {
                return null;
            }
            if (this.isTokenExpired(storedToken)) {
                TOKEN_STORE.remove(token);
                return null;
            }
            return storedToken;
        }
        catch (Exception e) {
            log.error("[ R2MO ] \u83b7\u53d6\u4ee4\u724c\u5931\u8d25: tokenId={}", (Object)token, (Object)e);
            return null;
        }
    }

    public boolean isExists(String token) {
        try {
            TransferToken storedToken = TOKEN_STORE.get(token);
            if (storedToken == null) {
                return false;
            }
            if (this.isTokenExpired(storedToken)) {
                TOKEN_STORE.remove(token);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            log.error("[ R2MO ] \u68c0\u67e5\u4ee4\u724c\u5b58\u5728\u6027\u5931\u8d25: tokenId={}", (Object)token, (Object)e);
            return false;
        }
    }

    public long getExpired(String token) {
        try {
            TransferToken storedToken = TOKEN_STORE.get(token);
            if (storedToken == null) {
                return -1L;
            }
            if (this.isTokenExpired(storedToken)) {
                TOKEN_STORE.remove(token);
                return -1L;
            }
            if (storedToken.getExpiredAt() != null) {
                long remaining = Duration.between(LocalDateTime.now(), storedToken.getExpiredAt()).toMillis();
                return Math.max(0L, remaining);
            }
            return -1L;
        }
        catch (Exception e) {
            log.error("[ R2MO ] \u83b7\u53d6\u4ee4\u724c\u5269\u4f59\u65f6\u95f4\u5931\u8d25: tokenId={}", (Object)token, (Object)e);
            return -1L;
        }
    }

    private boolean isTokenExpired(TransferToken token) {
        try {
            return token.getExpiredAt() != null && token.getExpiredAt().isBefore(LocalDateTime.now());
        }
        catch (Exception e) {
            return true;
        }
    }

    public int size() {
        return TOKEN_STORE.size();
    }

    public int runClean(boolean expiredOnly) {
        if (expiredOnly) {
            return this.cleanExpired();
        }
        return this.clean();
    }

    private int cleanExpired() {
        int cleanedCount = 0;
        LocalDateTime now = LocalDateTime.now();
        for (Map.Entry<String, TransferToken> entry : TOKEN_STORE.entrySet()) {
            try {
                TransferToken token = entry.getValue();
                if (token.getExpiredAt() == null || !token.getExpiredAt().isBefore(now)) continue;
                TOKEN_STORE.remove(entry.getKey());
                ++cleanedCount;
            }
            catch (Exception exception) {}
        }
        log.info("[ R2MO ] \u6e05\u7406\u8fc7\u671f\u4ee4\u724c\u5b8c\u6210\uff0c\u6e05\u7406\u6570\u91cf: {}", (Object)cleanedCount);
        return cleanedCount;
    }

    private int clean() {
        int size = TOKEN_STORE.size();
        TOKEN_STORE.clear();
        log.info("[ R2MO ] \u6e05\u7a7a\u6240\u6709\u4ee4\u724c\uff0c\u539f\u6570\u91cf: {}", (Object)size);
        return size;
    }
}

