/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.io.local.service;

import io.r2mo.base.io.modeling.FileRange;
import io.r2mo.base.io.modeling.StoreChunk;
import io.r2mo.base.io.transfer.TransferRequest;
import io.r2mo.base.io.transfer.TransferResult;
import io.r2mo.base.io.transfer.token.TransferToken;
import io.r2mo.base.io.transfer.token.TransferTokenService;
import io.r2mo.function.Fn;
import io.r2mo.io.component.node.StoreInit;
import io.r2mo.io.local.service.AbstractTransferService;
import io.r2mo.io.local.service.NodeManager;
import io.r2mo.io.local.transfer.TransDownload;
import io.r2mo.io.local.transfer.TransUpload;
import io.r2mo.io.modeling.TransferResponse;
import io.r2mo.io.service.TransferLargeService;
import io.r2mo.typed.common.Binary;
import io.r2mo.typed.common.Ref;
import io.r2mo.typed.exception.web._400BadRequestException;
import io.r2mo.typed.exception.web._404NotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalLargeService
extends AbstractTransferService
implements TransferLargeService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalLargeService.class);
    private static final Map<String, List<StoreChunk>> CHUNK_STORE = new ConcurrentHashMap<String, List<StoreChunk>>();
    private static final Map<String, List<StoreChunk>> UPLOADED_CHUNKS = new ConcurrentHashMap<String, List<StoreChunk>>();
    private static final Map<String, List<StoreChunk>> WAITING_CHUNKS = new ConcurrentHashMap<String, List<StoreChunk>>();
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    private final StoreInit<List<StoreChunk>> initializer;
    private final NodeManager nm = NodeManager.of();

    LocalLargeService(TransferTokenService token) {
        super(token);
        this.initializer = StoreInit.ofChunk();
    }

    public TransferResponse initialize(TransferRequest request) {
        this.verifyRequest(request);
        TransferToken token = (TransferToken)this.token.initialize((Object)request);
        if (Objects.isNull(token)) {
            throw new _400BadRequestException("[ R2MO ] \u4ee4\u724c\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u53c2\u6570\u7b49\u76f8\u5173\u6570\u636e\uff01");
        }
        List chunks = (List)this.initializer.input(request);
        this.nm.put(request.getNodeId(), chunks);
        this.initChunkList(token, chunks);
        TransferResponse response = this.initializer.output((Object)chunks);
        response.setCountChunk(Long.valueOf(chunks.size()));
        response.setToken(token.getToken());
        response.setSize(((StoreChunk)chunks.get(0)).getTotalSize());
        return response;
    }

    private void initChunkList(TransferToken token, List<StoreChunk> chunks) {
        String tokenId = token.getToken();
        CHUNK_STORE.put(tokenId, new ArrayList<StoreChunk>(chunks));
        UPLOADED_CHUNKS.put(tokenId, new ArrayList());
        WAITING_CHUNKS.put(tokenId, new ArrayList<StoreChunk>(chunks));
    }

    public TransferResult runUpload(String token, InputStream fileData, int index) {
        List<StoreChunk> chunks = this.findStoreChunks(token);
        StoreChunk targetChunk = this.findChunk(chunks, index);
        if (targetChunk == null) {
            throw new _404NotFoundException("[ R2MO ] \u6307\u5b9a\u7684\u5206\u5757\u4e0d\u5b58\u5728: " + index);
        }
        boolean uploadSuccess = TransUpload.of().write(targetChunk.getStorePath(), fileData);
        if (uploadSuccess) {
            this.updateChunkStatus(token, targetChunk, true);
            return TransferResult.SUCCESS;
        }
        return TransferResult.FAILURE;
    }

    public Binary runDownload(String token, int index) {
        List<StoreChunk> chunks = this.findStoreChunks(token);
        StoreChunk targetChunk = this.findChunk(chunks, index);
        if (targetChunk == null) {
            throw new _404NotFoundException("[ R2MO ] \u6307\u5b9a\u7684\u5206\u5757\u4e0d\u5b58\u5728: " + index);
        }
        return TransDownload.of().read(targetChunk.getStorePath(), FileRange.of((Long)targetChunk.getByteFrom(), (Long)targetChunk.getByteTo()));
    }

    public Binary runDownload(String filename, FileRange range) {
        return TransDownload.of().read(filename, range);
    }

    public List<StoreChunk> dataUploaded(String token) {
        return UPLOADED_CHUNKS.getOrDefault(token, Collections.emptyList());
    }

    public List<StoreChunk> dataWaiting(String token) {
        return WAITING_CHUNKS.getOrDefault(token, Collections.emptyList());
    }

    public List<StoreChunk> data(String token) {
        return this.findStoreChunks(token);
    }

    public List<StoreChunk> data(UUID id) {
        List<StoreChunk> chunks = (List<StoreChunk>)this.nm.find(id);
        return chunks != null ? chunks : Collections.emptyList();
    }

    public TransferResult cancel(String token) {
        try {
            this.cleanToken(token);
            this.token.runRevoke(token);
            return TransferResult.SUCCESS;
        }
        catch (Exception e) {
            log.error("[ R2MO ] \u53d6\u6d88\u4f20\u8f93\u5931\u8d25: token={}", (Object)token, (Object)e);
            return TransferResult.FAILURE;
        }
    }

    public TransferResult complete(String token) {
        this.validChunks(token);
        this.mergeChunks(token);
        this.cleanToken(token);
        this.token.runRevoke(token);
        this.rmChunk(token);
        return TransferResult.SUCCESS;
    }

    private void cleanToken(String token) {
        CHUNK_STORE.remove(token);
        UPLOADED_CHUNKS.remove(token);
        WAITING_CHUNKS.remove(token);
        log.info("[ R2MO ] \u6e05\u7406token\u5b8c\u6210\uff1a{}", (Object)token);
    }

    private void rmChunk(String token) {
        List<StoreChunk> allChunks = this.findStoreChunks(token);
        for (StoreChunk sc : allChunks) {
            TransUpload.of().rm(sc);
        }
        log.info("[ R2MO ] \u6587\u4ef6\u4f20\u8f93\u6210\u529f\uff0c\u6e05\u7406\u5206\u7247\u5b8c\u6210token\uff1a{}", (Object)token);
    }

    private void mergeChunks(String token) {
        List<StoreChunk> allChunks = this.findStoreChunks(token);
        Path finalFilePath = this.finalFilePath(token, allChunks);
        Fn.jvmOr(() -> Files.createDirectories(finalFilePath.getParent(), new FileAttribute[0]));
        List<StoreChunk> sortedChunks = allChunks.stream().sorted(Comparator.comparingLong(StoreChunk::getIndex)).toList();
        try (OutputStream outputStream = Files.newOutputStream(finalFilePath, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            for (StoreChunk chunk : sortedChunks) {
                Binary chunkData = TransDownload.of().read(chunk.getStorePath());
                if (chunkData == null) {
                    log.error("[ R2MO ] \u8bfb\u53d6\u5206\u5757\u5931\u8d25\uff0c\u65e0\u6cd5\u5408\u5e76: chunkId={}", (Object)chunk.getId());
                    throw new _400BadRequestException("[ R2MO ] \u8bfb\u53d6\u5206\u5757\u5931\u8d25\uff0c\u65e0\u6cd5\u5408\u5e76: chunkId=" + String.valueOf(chunk.getId()));
                }
                outputStream.write(chunkData.stream().readAllBytes());
                log.debug("[ R2MO ] \u5df2\u5408\u5e76\u5206\u5757: {} -> {}", (Object)chunk.getId(), (Object)finalFilePath);
            }
            outputStream.flush();
            log.info("[ R2MO ] \u6587\u4ef6\u5408\u5e76\u5b8c\u6210: path={}, \u603b\u5927\u5c0f: {} bytes", (Object)finalFilePath, (Object)Files.size(finalFilePath));
        }
        catch (IOException e) {
            log.error("[ R2MO ] \u5408\u5e76\u6587\u4ef6\u65f6\u53d1\u751fIO\u5f02\u5e38: path={}", (Object)finalFilePath, (Object)e);
            throw new _400BadRequestException("[ R2MO ] \u5408\u5e76\u6587\u4ef6\u65f6\u53d1\u751fIO\u5f02\u5e38: path=" + String.valueOf(finalFilePath));
        }
    }

    private Path finalFilePath(String token, List<StoreChunk> chunks) {
        TransferToken tokenInfo = this.token.runValidate(token);
        if (tokenInfo == null || tokenInfo.getRef() == null) {
            log.error("[ R2MO ] \u65e0\u6cd5\u786e\u5b9a\u6700\u7ec8\u6587\u4ef6\u8def\u5f84\uff1atoken={}", (Object)token);
            throw new _400BadRequestException("[ R2MO ] \u65e0\u6cd5\u786e\u5b9a\u6700\u7ec8\u6587\u4ef6\u8def\u5f84\uff1atoken=" + token);
        }
        String fileName = tokenInfo.getRef().refId().toString() + "-" + chunks.get(0).getFullFileName();
        return Paths.get(chunks.get(0).getStorePath(), fileName);
    }

    private void validChunks(String token) {
        List<StoreChunk> allChunks = this.findStoreChunks(token);
        List uploadedChunks = UPLOADED_CHUNKS.getOrDefault(token, Collections.emptyList());
        if (uploadedChunks.size() != allChunks.size()) {
            throw new _400BadRequestException("[ R2MO ] \u8fd8\u6709\u5206\u5757\u672a\u5b8c\u6210\u4e0a\u4f20\uff0c\u65e0\u6cd5\u5b8c\u6210\u4f20\u8f93\u3002\u5df2\u5b8c\u6210: " + uploadedChunks.size() + "/" + allChunks.size());
        }
        for (StoreChunk chunk : allChunks) {
            try {
                Binary data = TransDownload.of().read(chunk.getStorePath());
                if (data == null || data.length() != chunk.getSize().longValue()) {
                    log.warn("[ R2MO ] \u5206\u5757\u5927\u5c0f\u6821\u9a8c\u5931\u8d25: chunkId={}, \u671f\u671b: {}, \u5b9e\u9645: {}", new Object[]{chunk.getId(), chunk.getSize(), data != null ? Long.valueOf(data.length()) : "null"});
                }
                if (chunk.getChecksum() == null || chunk.getChecksum().isEmpty()) continue;
                String actualHash = this.calculateHash(data);
                if (chunk.getChecksum().equals(actualHash)) continue;
                log.warn("[ R2MO ] \u5206\u5757\u54c8\u5e0c\u6821\u9a8c\u5931\u8d25: chunkId={}", (Object)chunk.getId());
            }
            catch (Exception e) {
                log.warn("[ R2MO ] \u6821\u9a8c\u5206\u5757\u65f6\u53d1\u751f\u5f02\u5e38: chunkId={}", (Object)chunk.getId(), (Object)e);
            }
        }
        log.info("[ R2MO ] \u5b8c\u6210\u9a8c\u8bc1\uff1a token={}, \u5206\u5757\u6570\uff1a{}", (Object)token, (Object)uploadedChunks.size());
    }

    private String calculateHash(Binary data) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hashBytes = digest.digest((byte[])Fn.jvmOr(data.stream()::readAllBytes));
            return this.bytesToHex(hashBytes);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[ R2MO ] \u54c8\u5e0c\u7b97\u6cd5\u4e0d\u53ef\u7528", (Throwable)e);
            return null;
        }
    }

    private String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            hexChars[i * 2] = HEX_ARRAY[v >>> 4];
            hexChars[i * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    private List<StoreChunk> findStoreChunks(String token) {
        TransferToken tokenVerified = this.token.runValidate(token);
        if (Objects.isNull(tokenVerified)) {
            throw new _404NotFoundException("[ R2MO ] \u4ee4\u724c\u65e0\u6548\u6216\u5df2\u8fc7\u671f: " + token);
        }
        Ref ref = tokenVerified.getRef();
        if (Objects.isNull(ref) || Objects.isNull(ref.refId())) {
            throw new _404NotFoundException("[ R2MO ] \u4ee4\u724c\u5173\u8054\u7684\u8d44\u6e90\u5bf9\u8c61\u65e0\u6548: " + token);
        }
        List chunks = (List)this.nm.find(ref.refId());
        if (Objects.isNull(chunks)) {
            throw new _404NotFoundException("[ R2MO ] \u5206\u5757\u4fe1\u606f\u4e0d\u5b58\u5728: " + String.valueOf(ref.refId()));
        }
        return chunks;
    }

    private StoreChunk findChunk(List<StoreChunk> chunks, int index) {
        return chunks.stream().filter(chunk -> chunk.getIndex().equals(index)).findFirst().orElse(null);
    }

    private void updateChunkStatus(String token, StoreChunk chunk, boolean uploaded) {
        List uploadedList = UPLOADED_CHUNKS.getOrDefault(token, new ArrayList());
        List waitingList = WAITING_CHUNKS.getOrDefault(token, new ArrayList());
        if (uploaded) {
            uploadedList.add(chunk);
            waitingList.removeIf(c -> c.getId().equals(chunk.getId()));
        } else {
            waitingList.add(chunk);
            uploadedList.removeIf(c -> c.getId().equals(chunk.getId()));
        }
        UPLOADED_CHUNKS.put(token, uploadedList);
        WAITING_CHUNKS.put(token, waitingList);
    }
}

