/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.io.local.service;

import io.r2mo.base.io.modeling.FileRange;
import io.r2mo.base.io.modeling.StoreChunk;
import io.r2mo.base.io.modeling.StoreFile;
import io.r2mo.base.io.modeling.StoreNode;
import io.r2mo.base.io.transfer.TransferRequest;
import io.r2mo.base.io.transfer.TransferResult;
import io.r2mo.base.io.transfer.token.TransferToken;
import io.r2mo.base.io.transfer.token.TransferTokenService;
import io.r2mo.io.component.node.StoreInit;
import io.r2mo.io.local.service.AbstractTransferService;
import io.r2mo.io.local.transfer.TransDownload;
import io.r2mo.io.local.transfer.TransUpload;
import io.r2mo.io.modeling.TransferResponse;
import io.r2mo.io.service.TransferFileService;
import io.r2mo.typed.common.Binary;
import io.r2mo.typed.common.Ref;
import io.r2mo.typed.exception.web._400BadRequestException;
import io.r2mo.typed.exception.web._404NotFoundException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

class LocalFileService
extends AbstractTransferService
implements TransferFileService {
    private final StoreInit<StoreFile> initializer = StoreInit.ofFile();

    LocalFileService(TransferTokenService token) {
        super(token);
    }

    public TransferResponse initialize(TransferRequest request) {
        this.verifyRequest(request);
        TransferToken token = (TransferToken)this.token.initialize((Object)request);
        if (Objects.isNull(token)) {
            throw new _400BadRequestException("[ R2MO ] \u4ee4\u724c\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u53c2\u6570\u7b49\u76f8\u5173\u6570\u636e\uff01");
        }
        StoreFile file = (StoreFile)this.initializer.input(request);
        nm.put(request.getNodeId(), (StoreNode)file);
        TransferResponse response = this.initializer.output((Object)file);
        response.setToken(token.getToken());
        return response;
    }

    public TransferResult runUpload(String token, InputStream fileData) {
        StoreFile found = this.findStoreFile(token);
        boolean upload = TransUpload.of().write(found, fileData);
        return upload ? TransferResult.SUCCESS : TransferResult.FAILURE;
    }

    public Binary runDownload(String token) {
        StoreFile found = this.findStoreFile(token);
        return TransDownload.of().read(found);
    }

    public Binary runDownload(String token, FileRange range) {
        return null;
    }

    private StoreFile findStoreFile(String token) {
        TransferToken tokenVerified = this.token.runValidate(token);
        if (Objects.isNull(tokenVerified)) {
            throw new _404NotFoundException("[ R2MO ] \u4ee4\u724c\u65e0\u6548\u6216\u5df2\u8fc7\u671f: " + token);
        }
        Ref ref = tokenVerified.getRef();
        if (Objects.isNull(ref) || Objects.isNull(ref.refId())) {
            throw new _404NotFoundException("[ R2MO ] \u4ee4\u724c\u5173\u8054\u7684\u8d44\u6e90\u5bf9\u8c61\u65e0\u6548: " + token);
        }
        StoreFile found = (StoreFile)nm.find(ref.refId());
        if (Objects.isNull(found)) {
            throw new _404NotFoundException("[ R2MO ] \u8d44\u6e90\u5bf9\u8c61\u4e0d\u5b58\u5728: " + String.valueOf(ref.refId()));
        }
        return found;
    }

    public List<StoreChunk> data(String token) {
        return List.of();
    }

    public List<StoreChunk> data(UUID id) {
        return List.of();
    }

    public TransferResult cancel(String token) {
        return null;
    }

    public TransferResult complete(String token) {
        return null;
    }
}

