/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.io.local.service;

import io.r2mo.base.io.HTransfer;
import io.r2mo.base.io.transfer.HTransferAction;
import io.r2mo.base.io.transfer.HTransferService;
import io.r2mo.base.io.transfer.token.TransferTokenPool;
import io.r2mo.base.io.transfer.token.TransferTokenService;
import io.r2mo.io.local.service.LocalDirectoryService;
import io.r2mo.io.local.service.LocalFileService;
import io.r2mo.io.local.service.LocalLargeService;
import io.r2mo.io.local.service.LocalProgressService;
import io.r2mo.io.local.service.LocalStatService;
import io.r2mo.io.local.service.LocalTokenService;
import io.r2mo.io.service.MonitorProgressService;
import io.r2mo.io.service.MonitorStatService;
import io.r2mo.io.service.TransferDirectoryService;
import io.r2mo.io.service.TransferFileService;
import io.r2mo.io.service.TransferLargeService;
import io.r2mo.typed.annotation.SPID;
import io.r2mo.typed.cc.Cc;

@SPID(value="spi.io.transfer.DEFAULT")
public class HTransferLocal
implements HTransfer {
    private static final Cc<String, HTransferAction> CCT_ACTION = Cc.openThread();
    private static final Cc<String, HTransferService<?, ?, ?>> CCT_SERVICE = Cc.openThread();

    public TransferFileService serviceOfFile(TransferTokenService store) {
        Object cacheKey = store == null ? "default" : String.valueOf(store.hashCode());
        cacheKey = (String)cacheKey + "@" + LocalFileService.class.getName();
        return (TransferFileService)CCT_SERVICE.pick(() -> new LocalFileService(store), cacheKey);
    }

    public TransferLargeService serviceOfLarge(TransferTokenService store) {
        Object cacheKey = store == null ? "default" : String.valueOf(store.hashCode());
        cacheKey = (String)cacheKey + "@" + LocalLargeService.class.getName();
        return (TransferLargeService)CCT_SERVICE.pick(() -> new LocalLargeService(store), cacheKey);
    }

    public TransferDirectoryService serviceOfDirectory(TransferTokenService store) {
        Object cacheKey = store == null ? "default" : String.valueOf(store.hashCode());
        cacheKey = (String)cacheKey + "@" + LocalDirectoryService.class.getName();
        return (TransferDirectoryService)CCT_SERVICE.pick(() -> new LocalDirectoryService(store), cacheKey);
    }

    public TransferTokenService serviceToken(TransferTokenPool store) {
        Object cacheKey = store == null ? "default" : String.valueOf(store.hashCode());
        cacheKey = (String)cacheKey + "@" + LocalTokenService.class.getName();
        return (TransferTokenService)CCT_SERVICE.pick(() -> new LocalTokenService(store), cacheKey);
    }

    public MonitorProgressService actionProgress() {
        return (MonitorProgressService)CCT_ACTION.pick(LocalProgressService::new, (Object)LocalProgressService.class.getName());
    }

    public MonitorStatService actionStatistics() {
        return (MonitorStatService)CCT_ACTION.pick(LocalStatService::new, (Object)LocalStatService.class.getName());
    }
}

