/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.io.local.operation;

import cn.hutool.core.io.IoUtil;
import io.r2mo.function.Fn;
import io.r2mo.io.local.operation.SecurityMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemReader;
import org.bouncycastle.util.io.pem.PemWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SecurityIn {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecurityIn.class);

    SecurityIn() {
    }

    static InputStream inPublic(PublicKey publicKey) {
        return SecurityIn.inPem(publicKey.getAlgorithm() + " PUBLIC KEY", publicKey.getEncoded());
    }

    static InputStream inPrivate(PrivateKey privateKey) {
        return SecurityIn.inPem(privateKey.getAlgorithm() + " PRIVATE KEY", privateKey.getEncoded());
    }

    static InputStream inSecret(SecretKey secretKey) {
        String base64Key = Base64.toBase64String((byte[])secretKey.getEncoded());
        String pemContent = "-----BEGIN SECRET KEY-----\n" + base64Key + "\n-----END SECRET KEY-----\n";
        return new ByteArrayInputStream(pemContent.getBytes(StandardCharsets.UTF_8));
    }

    private static InputStream inPem(String title, byte[] encoded) {
        return (InputStream)Fn.jvmOr(() -> {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PemObject pemObject = new PemObject(title, encoded);
            try (PemWriter pemWriter = new PemWriter((Writer)new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8));){
                pemWriter.writeObject((PemObjectGenerator)pemObject);
            }
            return new ByteArrayInputStream(baos.toByteArray());
        });
    }

    static PublicKey inPublic(InputStream in) {
        PemObject pemObject = SecurityIn.inPem(in);
        String type = pemObject.getType();
        byte[] content = pemObject.getContent();
        String algorithm = SecurityIn.resolveAlgorithm(type);
        KeyFactory factory = (KeyFactory)Fn.jvmOr(() -> KeyFactory.getInstance(algorithm, "BC"));
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(content);
        return (PublicKey)Fn.jvmOr(() -> factory.generatePublic(keySpec));
    }

    static PrivateKey inPrivate(InputStream in) {
        PemObject pemObject = SecurityIn.inPem(in);
        String type = pemObject.getType();
        byte[] content = pemObject.getContent();
        String algorithm = SecurityIn.resolveAlgorithm(type);
        KeyFactory factory = (KeyFactory)Fn.jvmOr(() -> KeyFactory.getInstance(algorithm, "BC"));
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(content);
        return (PrivateKey)Fn.jvmOr(() -> factory.generatePrivate(keySpec));
    }

    static SecretKey inSecret(InputStream in) {
        if (in == null) {
            throw new IllegalArgumentException("[ R2MO ] SecretKey \u5904\u7406\u4e2d\u8f93\u5165\u6d41\u4e3a\u7a7a");
        }
        return (SecretKey)Fn.jvmOr(() -> {
            byte[] keyBytes = IoUtil.readBytes((InputStream)in);
            String keyString = new String(keyBytes, StandardCharsets.UTF_8);
            if (keyString.contains("-----BEGIN")) {
                String base64Key = keyString.replace("-----BEGIN SECRET KEY-----", "").replace("-----END SECRET KEY-----", "").replaceAll("\\s", "");
                keyBytes = Base64.decode((String)base64Key);
            }
            String algorithm = switch (keyBytes.length * 8) {
                case 128 -> "AES";
                case 168 -> "DESede";
                case 192 -> "AES";
                case 256 -> "AES";
                default -> "AES";
            };
            return new SecretKeySpec(keyBytes, algorithm);
        });
    }

    private static PemObject inPem(InputStream in) {
        if (Objects.isNull(in)) {
            throw new IllegalArgumentException("[ R2MO ] \u8f93\u5165\u6d41\u4e3a null");
        }
        return (PemObject)Fn.jvmOr(() -> {
            try (PemReader reader = new PemReader((Reader)new InputStreamReader(in, StandardCharsets.UTF_8));){
                PemObject pemObject = reader.readPemObject();
                if (Objects.isNull(pemObject)) {
                    throw new IllegalArgumentException("[ R2MO ] \u8bfb\u53d6\u5931\u8d25\uff0cPEM \u5bf9\u8c61\u4e3a null");
                }
                PemObject pemObject2 = pemObject;
                return pemObject2;
            }
        });
    }

    private static String resolveAlgorithm(String type) {
        if (type == null) {
            throw new IllegalArgumentException("[ R2MO ] PEM \u7c7b\u578b\u4e3a\u7a7a");
        }
        String upperType = type.toUpperCase(Locale.ROOT);
        for (Map.Entry<String, String> entry : SecurityMap.ALG_MAP.entrySet()) {
            if (!upperType.contains(entry.getKey())) continue;
            log.info("[ R2MO ] \u89e3\u6790 PEM \u7c7b\u578b: {} / \u4fa6\u6d4b\u7b97\u6cd5\u7c7b\u578b\uff1a{}", (Object)upperType, (Object)entry.getValue());
            return entry.getValue();
        }
        throw new IllegalArgumentException("[ R2MO ] \u65e0\u6cd5\u8bc6\u522b\u7684 PEM \u7b97\u6cd5\u7c7b\u578b: " + upperType);
    }

    static {
        Provider p = Security.getProvider("BC");
        if (Objects.isNull(p)) {
            p = new BouncyCastleProvider();
            Security.addProvider(p);
            log.info("[ R2MO ] \u4f7f\u7528\u5b89\u5168\u63d0\u4f9b\u8005: {}, \u7248\u672c: {}", (Object)p.getName(), (Object)p.getVersionStr());
        }
    }
}

