/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.io.local.operation;

import io.r2mo.function.Fn;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MetaFile {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetaFile.class);
    private static final String[] MULTI_EXT = new String[]{"tar.gz", "tar.bz2", "tar.xz", "tar.zst"};

    MetaFile() {
    }

    static String fileMime(String path) {
        Path pathObj = Paths.get(path, new String[0]);
        if (Files.isDirectory(pathObj, new LinkOption[0])) {
            return "";
        }
        return (String)Fn.jvmOr(() -> Files.probeContentType(pathObj));
    }

    static long fileSize(String path) {
        Path pathObj = Paths.get(path, new String[0]);
        if (Files.isDirectory(pathObj, new LinkOption[0])) {
            return 0L;
        }
        return (Long)Fn.jvmOr(() -> Files.size(pathObj), (Object)0L);
    }

    static String fileName(String path) {
        Path p = Paths.get(path, new String[0]);
        return p.getFileName() != null ? p.getFileName().toString() : "";
    }

    static String fileDirectory(String path) {
        if (path == null || path.isEmpty()) {
            return "";
        }
        try {
            Path p = Paths.get(path, new String[0]);
            if (Files.isDirectory(p, new LinkOption[0])) {
                return "";
            }
            Path parent = p.getParent();
            return parent != null ? parent.toString() : "";
        }
        catch (InvalidPathException e) {
            log.error("[ R2MO ] \u83b7\u53d6\u6587\u4ef6\u76ee\u5f55\u5931\u8d25: path={}, error={}", (Object)path, (Object)e.getMessage());
            return "";
        }
    }

    static String fileExtension(String path) {
        String name = MetaFile.fileName(path).toLowerCase();
        for (String ext : MULTI_EXT) {
            if (!name.endsWith("." + ext)) continue;
            return ext;
        }
        int dot = name.lastIndexOf(46);
        return dot >= 0 && dot < name.length() - 1 ? name.substring(dot + 1) : "";
    }
}

