/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.io.local.operation;

import jakarta.xml.bind.DatatypeConverter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.MessageDigest;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MetaCommon {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetaCommon.class);

    MetaCommon() {
    }

    static String metaChecksum(String path, String algorithm) {
        try {
            Path p = Paths.get(path, new String[0]);
            if (!Files.exists(p, new LinkOption[0])) {
                return "";
            }
            MessageDigest md = MessageDigest.getInstance(algorithm);
            byte[] bytes = Files.readAllBytes(p);
            byte[] digest = md.digest(bytes);
            return DatatypeConverter.printHexBinary((byte[])digest).toLowerCase();
        }
        catch (Exception e) {
            log.error("[ R2MO ] \u8ba1\u7b97\u6587\u4ef6\u54c8\u5e0c\u5931\u8d25: path={}, algorithm={}, error={}", new Object[]{path, algorithm, e.getMessage()});
            return "";
        }
    }

    static LocalDateTime metaModifiedAt(String path) {
        try {
            Path p = Paths.get(path, new String[0]);
            BasicFileAttributes attrs = Files.readAttributes(p, BasicFileAttributes.class, new LinkOption[0]);
            Instant instant = attrs.lastModifiedTime().toInstant();
            return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        }
        catch (IOException e) {
            log.error("[ R2MO ] \u83b7\u53d6\u6587\u4ef6\u4fee\u6539\u65f6\u95f4\u5931\u8d25: path={}, error={}", (Object)path, (Object)e.getMessage());
            return null;
        }
    }
}

