/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.io.local.operation;

import io.r2mo.base.io.HProgressor;
import io.r2mo.base.io.common.FileMem;
import io.r2mo.typed.common.Binary;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalZip {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalZip.class);

    LocalZip() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static Binary inBinary(Set<String> files, Set<FileMem> memSet, HProgressor progressRef) {
        if ((files == null || files.isEmpty()) && (memSet == null || memSet.isEmpty())) {
            throw new IllegalArgumentException("[ R2MO ] \u8f93\u5165\u6587\u4ef6\u96c6\u5408\u4e3a\u7a7a\uff01");
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            Binary binary;
            try (ZipOutputStream zos = new ZipOutputStream(baos);){
                ZipEntry entry;
                byte[] buffer = new byte[8192];
                long totalBytes = 0L;
                if (files != null) {
                    for (String filePath : files) {
                        Path path = Paths.get(filePath, new String[0]);
                        if (!Files.exists(path, new LinkOption[0])) {
                            log.warn("[ R2MO ] \u6587\u4ef6\u4e0d\u5b58\u5728: {}", (Object)filePath);
                            continue;
                        }
                        log.info("[ R2MO ] \u6b63\u5728\u538b\u7f29\u672c\u5730\u6587\u4ef6: {}", (Object)filePath);
                        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
                            int len;
                            entry = new ZipEntry(path.getFileName().toString());
                            zos.putNextEntry(entry);
                            while ((len = in.read(buffer)) != -1) {
                                zos.write(buffer, 0, len);
                                totalBytes += (long)len;
                                if (progressRef == null) continue;
                                try {
                                    progressRef.onProgress(totalBytes);
                                }
                                catch (Exception e) {
                                    log.debug("[ R2MO ] \u8fdb\u5ea6\u56de\u8c03\u5931\u8d25", (Throwable)e);
                                }
                            }
                            zos.closeEntry();
                        }
                    }
                }
                if (memSet != null) {
                    for (FileMem fileMem : memSet) {
                        String name = fileMem.name();
                        byte[] content = fileMem.content();
                        if (name == null || content == null) {
                            log.warn("[ R2MO ] \u5185\u5b58\u6587\u4ef6\u65e0\u6548: name={}, content={}", (Object)name, (Object)(content != null ? 1 : 0));
                            continue;
                        }
                        log.info("[ R2MO ] \u6b63\u5728\u538b\u7f29\u5185\u5b58\u6587\u4ef6: {}", (Object)name);
                        entry = new ZipEntry(name);
                        zos.putNextEntry(entry);
                        zos.write(content);
                        totalBytes += (long)content.length;
                        if (progressRef != null) {
                            try {
                                progressRef.onProgress(totalBytes);
                            }
                            catch (Exception e) {
                                log.debug("[ R2MO ] \u8fdb\u5ea6\u56de\u8c03\u5931\u8d25", (Throwable)e);
                            }
                        }
                        zos.closeEntry();
                    }
                }
                zos.finish();
                zos.flush();
                byte[] zipBytes = baos.toByteArray();
                int length = zipBytes.length;
                log.info("[ R2MO ] \u538b\u7f29\u5b8c\u6210\uff0c\u5171 {} \u5b57\u8282", (Object)length);
                if (progressRef != null) {
                    try {
                        progressRef.onComplete((long)length);
                    }
                    catch (Exception e) {
                        log.debug("[ R2MO ] \u5b8c\u6210\u56de\u8c03\u5931\u8d25", (Throwable)e);
                    }
                }
                binary = new Binary((InputStream)new ByteArrayInputStream(zipBytes)).length((long)length);
            }
            return binary;
        }
        catch (Exception e) {
            log.error("[ R2MO ] \u538b\u7f29\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
            if (progressRef != null) {
                try {
                    progressRef.onError(e);
                }
                catch (Exception ex) {
                    log.debug("[ R2MO ] \u9519\u8bef\u56de\u8c03\u6267\u884c\u5931\u8d25", (Throwable)ex);
                }
            }
            return null;
        }
    }
}

