/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.io.local.operation;

import cn.hutool.core.util.StrUtil;
import io.r2mo.base.io.HProgressor;
import io.r2mo.base.io.modeling.FileRange;
import io.r2mo.io.local.operation.FileRangeInputStream;
import io.r2mo.io.local.transfer.ChecksumUtil;
import io.r2mo.typed.common.Binary;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalRafReader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalRafReader.class);

    LocalRafReader() {
    }

    static Binary inBinary(String filename, FileRange fileRange, HProgressor progressRef) {
        if (StrUtil.isBlank((CharSequence)filename)) {
            log.warn("[ R2MO ] \u6587\u4ef6\u8bfb\u53d6\u53c2\u6570\u65e0\u6548:filename = {}", (Object)filename);
            return null;
        }
        Path filePath = Paths.get(filename, new String[0]);
        if (!Files.exists(filePath, new LinkOption[0])) {
            log.warn("[ R2MO ] \u6587\u4ef6\u4e0d\u5b58\u5728:path = {}", (Object)filePath);
            return null;
        }
        try {
            InputStream checksumStream = FileRangeInputStream.getInputStream(filePath, fileRange.getStart(), fileRange.getEnd());
            String checksum = ChecksumUtil.calculateChecksum(checksumStream, ChecksumUtil.HashAlgorithm.SHA256);
            checksumStream.close();
            InputStream dataStream = FileRangeInputStream.getInputStream(filePath, fileRange.getStart(), fileRange.getEnd());
            return new Binary(dataStream).checksum(checksum).length(fileRange.getLength().longValue());
        }
        catch (IOException e) {
            System.err.println("\u4e0b\u8f7d\u5206\u7247\u5931\u8d25\uff1a" + e.getMessage());
            return null;
        }
    }
}

