/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.io.local.operation;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.file.Path;

public class FileRangeInputStream
extends InputStream {
    private final RandomAccessFile raf;
    private final long startPos;
    private final long endPos;
    private long currentPos;
    private long bytesRemaining;

    public static InputStream getInputStream(Path filePath, long start, long end) throws IOException {
        return new FileRangeInputStream(filePath, start, end);
    }

    private FileRangeInputStream(Path filePath, long start, long end) throws IOException {
        this.raf = new RandomAccessFile(filePath.toFile(), "r");
        this.startPos = start;
        this.endPos = end;
        this.currentPos = start;
        this.bytesRemaining = end - start;
        this.validateParameters();
        this.raf.seek(this.startPos);
    }

    private void validateParameters() throws IOException {
        long fileLength = this.raf.length();
        if (this.startPos < 0L) {
            throw new IllegalArgumentException("\u8d77\u59cb\u4f4d\u7f6e\u4e0d\u80fd\u4e3a\u8d1f\u6570: " + this.startPos);
        }
        if (this.endPos < this.startPos) {
            throw new IllegalArgumentException("\u7ed3\u675f\u4f4d\u7f6e\u4e0d\u80fd\u5c0f\u4e8e\u8d77\u59cb\u4f4d\u7f6e: " + this.endPos + " < " + this.startPos);
        }
        if (this.startPos > fileLength) {
            throw new IllegalArgumentException("\u8d77\u59cb\u4f4d\u7f6e\u8d85\u8fc7\u6587\u4ef6\u957f\u5ea6: " + this.startPos + " > " + fileLength);
        }
        if (this.endPos > fileLength) {
            throw new IllegalArgumentException("\u7ed3\u675f\u4f4d\u7f6e\u8d85\u8fc7\u6587\u4ef6\u957f\u5ea6: " + this.endPos + " > " + fileLength);
        }
        if (this.bytesRemaining <= 0L) {
            throw new IllegalArgumentException("\u8bfb\u53d6\u957f\u5ea6\u5fc5\u987b\u5927\u4e8e0: " + this.bytesRemaining);
        }
    }

    @Override
    public int read() throws IOException {
        if (this.bytesRemaining <= 0L) {
            return -1;
        }
        int result = this.raf.read();
        if (result != -1) {
            ++this.currentPos;
            --this.bytesRemaining;
        }
        return result;
    }
}

