/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.io.local.transfer;

import io.r2mo.base.io.HStore;
import io.r2mo.base.io.HUri;
import io.r2mo.base.io.modeling.FileRange;
import io.r2mo.base.io.modeling.StoreFile;
import io.r2mo.spi.SPI;
import io.r2mo.typed.cc.Cc;
import io.r2mo.typed.common.Binary;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransDownload {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TransDownload.class);
    private static final Cc<String, TransDownload> CCT_DOWNLOAD = Cc.openThread();

    private TransDownload() {
    }

    public static TransDownload of() {
        return (TransDownload)CCT_DOWNLOAD.pick(TransDownload::new);
    }

    private static Result getPath(String relatePath) {
        HStore store = SPI.V_STORE;
        String path = HUri.UT.resolve((String)store.pHome(), (String)relatePath);
        log.info("[ R2MO ] - \u51c6\u5907\u4e0b\u8f7d\u5206\u5757\uff0c\u5b58\u50a8\u8def\u5f84\uff1a{}", (Object)path);
        return new Result(store, path);
    }

    public Binary read(StoreFile file) {
        return this.read(file.getStorePath());
    }

    public Binary read(String relatePath, FileRange range) {
        Result result = TransDownload.getPath(relatePath);
        log.info("[ R2MO ] -\u8bfb\u53d6\u6587\u4ef6\uff1a{} \uff0c\u8303\u56f4\uff1a{} ", (Object)relatePath, (Object)range);
        return result.store().inBinary(result.path(), range, null);
    }

    public Binary read(String relatePath) {
        Result result = TransDownload.getPath(relatePath);
        return result.store().inBinary(result.path);
    }

    private record Result(HStore store, String path) {
    }
}

