/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.io.local.transfer;

import io.r2mo.base.io.modeling.StoreChunk;
import io.r2mo.base.io.transfer.TransferRequest;
import io.r2mo.base.io.transfer.TransferType;
import io.r2mo.io.common.RFS;
import io.r2mo.io.enums.TransferStatus;
import io.r2mo.io.local.transfer.ChunkSession;
import io.r2mo.io.local.transfer.DownloadResult;
import io.r2mo.io.modeling.TransferProgress;
import io.r2mo.typed.common.Binary;
import io.r2mo.typed.domain.extension.AbstractStoreObject;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkDownloader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChunkDownloader.class);
    private final RFS rfs;
    private final ExecutorService executorService;

    public ChunkDownloader(RFS rfs, int threadPoolSize) {
        this.rfs = rfs;
        this.executorService = Executors.newFixedThreadPool(threadPoolSize);
    }

    private List<StoreChunk> getSort(List<StoreChunk> chunks) {
        return chunks.stream().sorted(Comparator.comparing(StoreChunk::getIndex)).toList();
    }

    public CompletableFuture<DownloadResult> downloadFile(String transferId, String token) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                log.info("\u5f00\u59cb\u5206\u7247\u4e0b\u8f7d: {}, token: {}", (Object)transferId, (Object)token);
                List chunks = this.rfs.getAllChunks(token);
                if (chunks == null || chunks.isEmpty()) {
                    throw new RuntimeException("\u5206\u7247\u4fe1\u606f\u4e0d\u5b58\u5728: " + token);
                }
                Path localPath = Paths.get(((StoreChunk)chunks.get(0)).getStorePath(), token);
                Files.createDirectories(localPath.getParent(), new FileAttribute[0]);
                this.downloadChunksParallel(token, chunks, localPath);
                long downloadedSize = Files.size(localPath);
                log.info("\u5206\u7247\u4e0b\u8f7d\u5b8c\u6210: {}, \u5927\u5c0f: {} bytes", (Object)token, (Object)downloadedSize);
                return new DownloadResult(true, token, downloadedSize, localPath.toString(), "\u4e0b\u8f7d\u6210\u529f");
            }
            catch (Exception e) {
                log.error("\u5206\u7247\u4e0b\u8f7d\u5931\u8d25: {}", (Object)token, (Object)e);
                throw new RuntimeException("\u5206\u7247\u4e0b\u8f7d\u5931\u8d25: " + token, e);
            }
        }, this.executorService);
    }

    private List<StoreChunk> getDownloadChunks(String token) {
        return this.rfs.getAllChunks(token).stream().filter(StoreChunk::getDone).toList();
    }

    public TransferProgress getDownloadProgress(String token, ChunkSession session) {
        try {
            List allChunks = this.rfs.getAllChunks(token);
            int totalChunks = allChunks.size();
            int downloadedChunks = this.getDownloadChunks(token).size();
            double progress = totalChunks > 0 ? (double)downloadedChunks * 100.0 / (double)totalChunks : 0.0;
            long totalSize = allChunks.stream().mapToLong(AbstractStoreObject::getSize).sum();
            long downloadedSize = this.getDownloadChunks(token).stream().mapToLong(AbstractStoreObject::getSize).sum();
            return new TransferProgress(token, session.getSessionId(), Long.valueOf(downloadedSize), Long.valueOf(totalSize), Double.valueOf(progress), Boolean.valueOf(true), TransferStatus.TRANSFERRING, TransferType.UPLOAD, null, null, null, null);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4e0b\u8f7d\u8fdb\u5ea6\u5931\u8d25: {}", (Object)token, (Object)e);
            return new TransferProgress(token, session.getSessionId(), null, null, null, Boolean.valueOf(true), null, TransferType.UPLOAD, null, null, e.getMessage(), e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadChunksParallel(String token, List<StoreChunk> chunks, Path localPath) throws Exception {
        List<StoreChunk> sortedChunks = this.getSort(chunks);
        Path tempDir = localPath.getParent().resolve("temp_" + String.valueOf(UUID.randomUUID()));
        Files.createDirectories(tempDir, new FileAttribute[0]);
        try {
            List<CompletableFuture> downloadFutures = sortedChunks.stream().map(chunk -> CompletableFuture.runAsync(() -> {
                try {
                    this.downloadSingleChunk(token, (StoreChunk)chunk, tempDir);
                }
                catch (Exception e) {
                    throw new RuntimeException("\u5206\u7247\u4e0b\u8f7d\u5931\u8d25: " + String.valueOf(chunk.getId()), e);
                }
            }, this.executorService)).toList();
            CompletableFuture.allOf(downloadFutures.toArray(new CompletableFuture[0])).get();
            this.mergeChunks(sortedChunks, tempDir, localPath);
        }
        finally {
            this.cleanupTempFiles(tempDir);
        }
    }

    private void downloadSingleChunk(String token, StoreChunk chunk, Path tempDir) {
        try {
            Binary chunkData = this.rfs.ioDownload(this.createChunkRequest(token), chunk.getIndex().intValue());
            if (chunkData == null) {
                throw new RuntimeException("\u5206\u7247\u4e0b\u8f7d\u8fd4\u56de\u7a7a\u6570\u636e: " + String.valueOf(chunk.getId()));
            }
            Path chunkFile = tempDir.resolve(chunk.getId().toString());
            Files.write(chunkFile, chunkData.stream().readAllBytes(), StandardOpenOption.CREATE);
            chunk.setDone(Boolean.valueOf(true));
            log.debug("\u5206\u7247\u4e0b\u8f7d\u6210\u529f: {}, \u5927\u5c0f: {}", (Object)chunk.getId(), (Object)chunkData.length());
        }
        catch (Exception e) {
            log.error("\u5206\u7247\u4e0b\u8f7d\u5f02\u5e38: {}", (Object)chunk.getId(), (Object)e);
            throw new RuntimeException("\u5206\u7247\u4e0b\u8f7d\u5931\u8d25", e);
        }
    }

    private void mergeChunks(List<StoreChunk> chunks, Path tempDir, Path outputPath) throws IOException {
        List<StoreChunk> sortedChunks = this.getSort(chunks);
        try (OutputStream outputStream = Files.newOutputStream(outputPath, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            for (StoreChunk chunk : sortedChunks) {
                Path chunkFile = tempDir.resolve(chunk.getId().toString());
                if (!Files.exists(chunkFile, new LinkOption[0])) continue;
                byte[] chunkData = Files.readAllBytes(chunkFile);
                outputStream.write(chunkData);
            }
        }
    }

    private TransferRequest createChunkRequest(String token) {
        TransferRequest request = new TransferRequest();
        request.setNodeId(UUID.randomUUID());
        request.setIsMultipart(Boolean.valueOf(true));
        request.setToken(token);
        return request;
    }

    private void cleanupTempFiles(Path tempDir) {
        try {
            if (Files.exists(tempDir, new LinkOption[0])) {
                Files.walk(tempDir, new FileVisitOption[0]).sorted((a, b) -> b.compareTo((Path)a)).forEach(path -> {
                    try {
                        Files.deleteIfExists(path);
                    }
                    catch (IOException e) {
                        log.warn("\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u5931\u8d25: {}", path, (Object)e);
                    }
                });
            }
        }
        catch (IOException e) {
            log.warn("\u6e05\u7406\u4e34\u65f6\u6587\u4ef6\u5931\u8d25: {}", (Object)tempDir, (Object)e);
        }
    }

    public void shutdown() {
        this.executorService.shutdown();
        log.info("\u5206\u7247\u4e0b\u8f7d\u5668\u5df2\u5173\u95ed");
    }
}

