/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.io.local.operation;

import io.r2mo.function.Fn;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;

class MetaIs {
    MetaIs() {
    }

    static boolean isHidden(String fullPath) {
        Path path = Paths.get(fullPath, new String[0]);
        return (Boolean)Fn.jvmOr(() -> Files.exists(path, new LinkOption[0]) && Files.isHidden(path));
    }

    static boolean isReadOnly(String fullPath) {
        Path path = Paths.get(fullPath, new String[0]);
        return Files.exists(path, new LinkOption[0]) && !Files.isWritable(path);
    }

    static boolean isExist(String fullPath) {
        Path path = Paths.get(fullPath, new String[0]);
        return Files.exists(path, new LinkOption[0]);
    }

    static boolean isDirectory(String fullPath) {
        Path path = Paths.get(fullPath, new String[0]);
        return Files.isDirectory(path, new LinkOption[0]);
    }

    static boolean isFile(String fullPath) {
        Path path = Paths.get(fullPath, new String[0]);
        return Files.isRegularFile(path, new LinkOption[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean isEmpty(String fullPath) {
        if (fullPath == null) return true;
        if (fullPath.isEmpty()) {
            return true;
        }
        try {
            Path path = Paths.get(fullPath, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                return true;
            }
            if (Files.isDirectory(path, new LinkOption[0])) {
                try (Stream<Path> stream = Files.list(path);){
                    boolean bl = stream.findFirst().isEmpty();
                    return bl;
                }
            }
            if (!Files.isRegularFile(path, new LinkOption[0])) return false;
            if (Files.size(path) != 0L) return false;
            return true;
        }
        catch (Exception e) {
            return true;
        }
    }
}

