/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.io.local.service;

import io.r2mo.base.io.modeling.StoreNode;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

final class NodeManager {
    private static final ConcurrentMap<UUID, StoreNode> NODE_MAP = new ConcurrentHashMap<UUID, StoreNode>();
    private static NodeManager INSTANCE;

    private NodeManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static NodeManager of() {
        Class<NodeManager> clazz = NodeManager.class;
        synchronized (NodeManager.class) {
            if (Objects.isNull(INSTANCE)) {
                INSTANCE = new NodeManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    void put(UUID nodeId, StoreNode node) {
        NODE_MAP.put(nodeId, node);
    }

    void remove(UUID nodeId) {
        NODE_MAP.remove(nodeId);
    }

    <T extends StoreNode> T find(UUID nodeId) {
        return (T)((StoreNode)NODE_MAP.getOrDefault(nodeId, null));
    }
}

