/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.io.local.operation;

import io.r2mo.function.Fn;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalWriter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalWriter.class);

    LocalWriter() {
    }

    static boolean rm(String filename) {
        Path path = Paths.get(filename, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IllegalArgumentException("[ R2MO ] \u5220\u9664\u7684\u6587\u4ef6/\u76ee\u5f55\u4e0d\u5b58\u5728\uff1a" + filename);
        }
        boolean isDirectory = Files.isDirectory(path, new LinkOption[0]);
        if (isDirectory) {
            LocalWriter.directoryDelete(path);
        } else {
            Fn.jvmAt(() -> Files.delete(path));
        }
        return true;
    }

    static boolean write(String filename, String content, boolean append) {
        Path path = Paths.get(filename, new String[0]);
        LocalWriter.pathParent(path);
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, append ? StandardOpenOption.APPEND : StandardOpenOption.CREATE);){
            writer.write(content);
        }
        catch (IOException e) {
            log.error("[ R2MO ] \u5199\u5165\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef\uff1a" + filename, (Throwable)e);
            return false;
        }
        return true;
    }

    static boolean mkdir(String dir) {
        if (null == dir || dir.isBlank()) {
            return false;
        }
        Path path = Paths.get(dir, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            log.warn("[ R2MO ] \u76ee\u5f55\u5df2\u5b58\u5728\uff0c\u65e0\u9700\u521b\u5efa\uff1a{}", (Object)dir);
            return true;
        }
        Fn.jvmAt(() -> Files.createDirectories(path, new FileAttribute[0]));
        return true;
    }

    static boolean move(String from, String to) {
        Path fromPath = LocalWriter.pathSource(from);
        Path toPath = Paths.get(to, new String[0]);
        boolean isDirectoryF = Files.isDirectory(fromPath, new LinkOption[0]);
        boolean isDirectoryT = Files.isDirectory(toPath, new LinkOption[0]);
        if (isDirectoryF) {
            if (Files.exists(toPath, new LinkOption[0])) {
                if (!isDirectoryT) {
                    throw new IllegalStateException("[ R2MO ] \u4e0d\u80fd\u79fb\u52a8\u5230\u6587\u4ef6\uff1a" + to);
                }
                Path targetPath = toPath.resolve(fromPath.getFileName());
                LocalWriter.directoryMove(fromPath, targetPath);
            } else {
                LocalWriter.directoryMove(fromPath, toPath);
            }
        } else if (Files.exists(toPath, new LinkOption[0])) {
            if (isDirectoryT) {
                Path targetFile = toPath.resolve(fromPath.getFileName());
                LocalWriter.fileMove(fromPath, targetFile);
            } else {
                LocalWriter.fileMove(fromPath, toPath);
            }
        } else {
            LocalWriter.pathParent(toPath);
            LocalWriter.fileMove(fromPath, toPath);
        }
        return true;
    }

    static boolean copy(String from, String to) {
        Path fromPath = LocalWriter.pathSource(from);
        Path toPath = Paths.get(to, new String[0]);
        boolean isDirectoryF = Files.isDirectory(fromPath, new LinkOption[0]);
        boolean isDirectoryT = Files.isDirectory(toPath, new LinkOption[0]);
        if (isDirectoryF) {
            if (Files.exists(toPath, new LinkOption[0])) {
                if (!isDirectoryT) {
                    throw new IllegalStateException("[ R2MO ] \u4e0d\u80fd\u590d\u5236\u5230\u6587\u4ef6\uff1a" + to);
                }
                LocalWriter.directoryCopy(fromPath, toPath.resolve(fromPath.getFileName()));
            } else {
                LocalWriter.directoryCopy(fromPath, toPath);
            }
        } else if (Files.exists(toPath, new LinkOption[0])) {
            if (isDirectoryT) {
                Path targetFile = toPath.resolve(fromPath.getFileName());
                LocalWriter.fileCopy(fromPath, targetFile);
            } else {
                LocalWriter.fileCopy(fromPath, toPath);
            }
        } else {
            LocalWriter.mkdir(to);
            Path targetFile = toPath.resolve(fromPath.getFileName());
            LocalWriter.fileCopy(fromPath, targetFile);
        }
        return true;
    }

    static void fileCopy(Path source, Path target) {
        Fn.jvmAt(() -> Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING));
    }

    static void fileMove(Path source, Path target) {
        Fn.jvmAt(() -> Files.move(source, target, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE));
    }

    static void directoryMove(final Path source, final Path target) {
        Fn.jvmAt(() -> Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path targetFile = target.resolve(source.relativize(file));
                LocalWriter.pathParent(targetFile);
                Files.move(file, targetFile, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        }));
    }

    static void directoryDelete(Path directory) {
        Fn.jvmAt(() -> Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (exc == null) {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
                throw exc;
            }
        }));
    }

    static void directoryCopy(final Path source, final Path target) {
        Fn.jvmAt(() -> Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Path targetDir = target.resolve(source.relativize(dir));
                Files.createDirectories(targetDir, new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path targetFile = target.resolve(source.relativize(file));
                Files.copy(file, targetFile, StandardCopyOption.REPLACE_EXISTING);
                return FileVisitResult.CONTINUE;
            }
        }));
    }

    private static void pathParent(Path path) {
        Path parent = path.getParent();
        if (parent != null && Files.notExists(parent, new LinkOption[0])) {
            Fn.jvmAt(() -> Files.createDirectories(parent, new FileAttribute[0]));
        }
    }

    private static Path pathSource(String from) {
        Path fromPath = Paths.get(from, new String[0]);
        if (Files.notExists(fromPath, new LinkOption[0])) {
            throw new IllegalArgumentException("[ R2MO ] \u6e90\u6587\u4ef6/\u76ee\u5f55\u4e0d\u5b58\u5728\uff1a" + from);
        }
        return fromPath;
    }
}

