/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.io.local.operation;

import io.r2mo.base.io.HProgressor;
import io.r2mo.io.local.transfer.HHome;
import io.r2mo.spi.SPI;
import io.r2mo.typed.common.Binary;
import io.r2mo.typed.exception.web._501NotSupportException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalHighway {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalHighway.class);

    LocalHighway() {
    }

    static String findHome() {
        List found = SPI.findMany(HHome.class);
        if (found.isEmpty()) {
            return "";
        }
        if (found.size() > 1) {
            throw new _501NotSupportException("[ R2MO ] \u672c\u5730\u5b58\u50a8\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a Home \u5b9e\u73b0\uff0c\u5f53\u524d\u53d1\u73b0\u591a\u4e2a\uff0c\u8bf7\u68c0\u67e5 SPI \u914d\u7f6e\uff01");
        }
        return ((HHome)found.get(0)).ioHome();
    }

    public static Binary read(String filename, HProgressor progressCallback) {
        if (filename == null || filename.isEmpty()) {
            log.warn("[ R2MO ] \u6587\u4ef6\u8bfb\u53d6\u53c2\u6570\u65e0\u6548: filename={}", (Object)filename);
            return null;
        }
        try {
            Path filePath = Paths.get(filename, new String[0]);
            if (!Files.exists(filePath, new LinkOption[0])) {
                log.warn("[ R2MO ] \u6587\u4ef6\u4e0d\u5b58\u5728: path={}", (Object)filename);
                return null;
            }
            long fileSize = Files.size(filePath);
            InputStream inputStream = Files.newInputStream(filePath, StandardOpenOption.READ);
            if (progressCallback != null) {
                try {
                    progressCallback.onProgress(0L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return new Binary(inputStream).length(fileSize);
        }
        catch (Exception e) {
            log.error("[ R2MO ] \u6587\u4ef6\u8bfb\u53d6\u5931\u8d25: path={}", (Object)filename, (Object)e);
            if (progressCallback != null) {
                try {
                    progressCallback.onError(e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static boolean write(String filename, InputStream in, HProgressor progressCallback) {
        if (filename == null || filename.isEmpty() || in == null) {
            log.warn("[ R2MO ] \u6587\u4ef6\u5199\u5165\u53c2\u6570\u65e0\u6548: filename={}, inputStream={}", (Object)filename, (Object)in);
            return false;
        }
        Path filePath = null;
        try {
            filePath = Paths.get(filename, new String[0]);
            Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
            return LocalHighway.performNioWrite(filePath, in, progressCallback);
        }
        catch (Exception e) {
            log.error("[ R2MO ] \u6587\u4ef6\u5199\u5165\u5931\u8d25: path={}", (Object)filename, (Object)e);
            if (progressCallback != null) {
                try {
                    progressCallback.onError(e);
                }
                catch (Exception callbackEx) {
                    log.debug("[ R2MO ] \u8fdb\u5ea6\u56de\u8c03\u9519\u8bef\u5904\u7406\u5931\u8d25", (Throwable)callbackEx);
                }
            }
            if (filePath != null) {
                try {
                    Files.deleteIfExists(filePath);
                }
                catch (IOException deleteEx) {
                    log.debug("[ R2MO ] \u6e05\u7406\u4e34\u65f6\u6587\u4ef6\u5931\u8d25: path={}", (Object)filename, (Object)deleteEx);
                }
            }
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static boolean performNioWrite(Path filePath, InputStream inputStream, HProgressor progressCallback) {
        int bufferSize = 65536;
        try (ReadableByteChannel inputChannel = Channels.newChannel(inputStream);){
            boolean bl;
            block25: {
                FileChannel fileChannel = FileChannel.open(filePath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE, StandardOpenOption.SYNC);
                try {
                    int bytesRead;
                    ByteBuffer buffer = ByteBuffer.allocateDirect(65536);
                    long totalBytes = 0L;
                    long lastCallbackBytes = 0L;
                    long callbackInterval = 0x100000L;
                    while ((bytesRead = inputChannel.read(buffer)) != -1) {
                        buffer.flip();
                        while (buffer.hasRemaining()) {
                            fileChannel.write(buffer);
                        }
                        if (progressCallback != null && (totalBytes += (long)bytesRead) - lastCallbackBytes >= 0x100000L) {
                            try {
                                progressCallback.onProgress(totalBytes);
                                lastCallbackBytes = totalBytes;
                            }
                            catch (Exception callbackEx) {
                                log.debug("[ R2MO ] \u8fdb\u5ea6\u56de\u8c03\u6267\u884c\u5931\u8d25", (Throwable)callbackEx);
                            }
                        }
                        buffer.clear();
                    }
                    fileChannel.force(true);
                    if (progressCallback != null) {
                        try {
                            progressCallback.onComplete(totalBytes);
                        }
                        catch (Exception callbackEx) {
                            log.debug("[ R2MO ] \u5b8c\u6210\u56de\u8c03\u6267\u884c\u5931\u8d25", (Throwable)callbackEx);
                        }
                    }
                    log.debug("[ R2MO ] NIO \u6587\u4ef6\u5199\u5165\u5b8c\u6210: path={}, size={} bytes", (Object)filePath, (Object)totalBytes);
                    bl = true;
                    if (fileChannel == null) break block25;
                }
                catch (Throwable throwable) {
                    if (fileChannel != null) {
                        try {
                            fileChannel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                fileChannel.close();
            }
            return bl;
        }
        catch (Exception e) {
            log.error("[ R2MO ] NIO \u6587\u4ef6\u5199\u5165\u5931\u8d25: path={}", (Object)filePath, (Object)e);
            if (progressCallback != null) {
                try {
                    progressCallback.onError(e);
                }
                catch (Exception callbackEx) {
                    log.debug("[ R2MO ] \u8fdb\u5ea6\u56de\u8c03\u9519\u8bef\u5904\u7406\u5931\u8d25", (Throwable)callbackEx);
                }
            }
            return false;
        }
    }
}

