/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.io.local.operation;

import io.r2mo.base.io.HProgressor;
import io.r2mo.base.io.common.FileMem;
import io.r2mo.io.local.operation.HStoreLocalMeta;
import io.r2mo.io.local.operation.LocalHighway;
import io.r2mo.io.local.operation.LocalReader;
import io.r2mo.io.local.operation.LocalWriter;
import io.r2mo.io.local.operation.LocalZip;
import io.r2mo.io.local.operation.SecurityIn;
import io.r2mo.typed.annotation.SPID;
import io.r2mo.typed.common.Binary;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.crypto.SecretKey;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SPID(value="spi.io.store.DEFAULT")
public class HStoreLocal
extends HStoreLocalMeta {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HStoreLocal.class);

    public String pHome() {
        return LocalHighway.findHome();
    }

    public boolean cp(String source, String target) {
        return LocalWriter.copy(source, target);
    }

    public boolean rm(String filename) {
        return LocalWriter.rm(filename);
    }

    public boolean rm(Set<String> filenameSet) {
        if (filenameSet == null || filenameSet.isEmpty()) {
            return true;
        }
        return filenameSet.parallelStream().allMatch(LocalWriter::rm);
    }

    public boolean write(String filename, String content, boolean append) {
        return LocalWriter.write(filename, content, append);
    }

    public boolean write(String filename, InputStream in, HProgressor progress) {
        return LocalHighway.write(filename, in, progress);
    }

    public Binary inBinary(String filename, HProgressor progress) {
        return LocalHighway.read(filename, progress);
    }

    public Binary inBinary(Set<String> files, Set<FileMem> memSet, HProgressor progress) {
        return LocalZip.inBinary(files, memSet, progress);
    }

    public boolean mkdir(String dir) {
        return LocalWriter.mkdir(dir);
    }

    public boolean mv(String from, String to) {
        return LocalWriter.move(from, to);
    }

    public boolean mv(ConcurrentMap<String, String> vectorMap) {
        if (vectorMap == null || vectorMap.isEmpty()) {
            return true;
        }
        return vectorMap.entrySet().parallelStream().allMatch(entry -> LocalWriter.move((String)entry.getKey(), (String)entry.getValue()));
    }

    public boolean mkdir(Set<String> dirs) {
        if (dirs == null || dirs.isEmpty()) {
            return true;
        }
        return dirs.parallelStream().allMatch(LocalWriter::mkdir);
    }

    public InputStream inStream(File file) {
        return this.inStream(this.toURL(file));
    }

    public InputStream inStream(Path path) {
        return this.inStream(this.toURL(path));
    }

    public PrivateKey inPrivate(String filename) {
        return this.inPrivate(this.inStream(filename));
    }

    public PrivateKey inPrivate(InputStream in) {
        return SecurityIn.inPrivate(in);
    }

    public PublicKey inPublic(String filename) {
        return this.inPublic(this.inStream(filename));
    }

    public PublicKey inPublic(InputStream in) {
        return SecurityIn.inPublic(in);
    }

    public SecretKey inSecret(String filename) {
        return this.inSecret(this.inStream(filename));
    }

    public SecretKey inSecret(InputStream in) {
        return SecurityIn.inSecret(in);
    }

    public boolean write(String filename, PrivateKey key) {
        log.info("[ R2MO ] \uff08\u975e\u5bf9\u79f0\uff09\u5199\u5165\u79c1\u94a5 PrivateKey \u5230\u6587\u4ef6\uff1a{}", (Object)filename);
        return this.write(filename, SecurityIn.inPrivate(key));
    }

    public boolean write(String filename, PublicKey key) {
        log.info("[ R2MO ] \uff08\u975e\u5bf9\u79f0\uff09\u5199\u5165\u516c\u94a5 PublicKey \u5230\u6587\u4ef6\uff1a{}", (Object)filename);
        return this.write(filename, SecurityIn.inPublic(key));
    }

    public boolean write(String filename, SecretKey key) {
        log.info("[ R2MO ] \uff08\u5bf9\u79f0\uff09\u5199\u5165\u5bc6\u94a5 SecretKey \u5230\u6587\u4ef6\uff1a{}", (Object)filename);
        return this.write(filename, SecurityIn.inSecret(key));
    }

    public URL toURL(String filename) {
        if (null == filename || filename.isBlank()) {
            return null;
        }
        Path path = Path.of(filename, new String[0]);
        return this.toURL(path);
    }

    public List<String> lsFiles(String filename, String keyword) {
        return LocalReader.lsFiles(filename, keyword);
    }

    public List<String> lsFilesN(String filename, String keyword) {
        return LocalReader.lsFilesN(filename, keyword);
    }

    public List<String> lsDirs(String filename) {
        return LocalReader.lsDirs(filename);
    }

    public List<String> lsDirsN(String filename) {
        return LocalReader.lsDirsN(filename);
    }
}

