/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.io.local;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;

class LocalIs {
    LocalIs() {
    }

    static boolean isExist(String filename) {
        Path path = Paths.get(filename, new String[0]);
        return Files.exists(path, new LinkOption[0]);
    }

    static boolean isDirectory(String filename) {
        Path path = Paths.get(filename, new String[0]);
        return Files.isDirectory(path, new LinkOption[0]);
    }

    static boolean isFile(String filename) {
        Path path = Paths.get(filename, new String[0]);
        return Files.isRegularFile(path, new LinkOption[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean isEmpty(String filename) {
        if (filename == null) return true;
        if (filename.isEmpty()) {
            return true;
        }
        try {
            Path path = Paths.get(filename, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                return true;
            }
            if (Files.isDirectory(path, new LinkOption[0])) {
                try (Stream<Path> stream = Files.list(path);){
                    boolean bl = stream.findFirst().isEmpty();
                    return bl;
                }
            }
            if (!Files.isRegularFile(path, new LinkOption[0])) return false;
            if (Files.size(path) != 0L) return false;
            return true;
        }
        catch (Exception e) {
            return true;
        }
    }
}

