/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.io.local;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;

class LocalCompare {
    LocalCompare() {
    }

    static boolean isSame(String path1, String path2) {
        try {
            if (path1 == null && path2 == null) {
                return true;
            }
            if (path1 == null || path2 == null) {
                return false;
            }
            Path p1 = Paths.get(path1, new String[0]);
            Path p2 = Paths.get(path2, new String[0]);
            return LocalCompare.comparePaths(p1, p2);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean comparePaths(Path path1, Path path2) throws IOException {
        boolean isDir2;
        boolean exists1 = Files.exists(path1, new LinkOption[0]);
        boolean exists2 = Files.exists(path2, new LinkOption[0]);
        if (!exists1 && !exists2) {
            return true;
        }
        if (!exists1 || !exists2) {
            return false;
        }
        if (path1.equals(path2) || path1.normalize().equals(path2.normalize())) {
            return true;
        }
        boolean isDir1 = Files.isDirectory(path1, new LinkOption[0]);
        if (isDir1 != (isDir2 = Files.isDirectory(path2, new LinkOption[0]))) {
            return false;
        }
        if (isDir1) {
            return LocalCompare.compareDirectories(path1, path2);
        }
        return LocalCompare.compareFiles(path1, path2);
    }

    private static boolean compareFiles(Path file1, Path file2) throws IOException {
        long size2;
        String fileName2;
        String fileName1 = file1.getFileName().toString();
        if (!fileName1.equals(fileName2 = file2.getFileName().toString())) {
            return false;
        }
        long size1 = Files.size(file1);
        if (size1 != (size2 = Files.size(file2))) {
            return false;
        }
        return Files.mismatch(file1, file2) == -1L;
    }

    private static boolean compareDirectories(Path dir1, Path dir2) throws IOException {
        Path[] list2;
        Path[] list1 = (Path[])Files.list(dir1).sorted(Comparator.comparing(Path::getFileName)).toArray(Path[]::new);
        if (list1.length != (list2 = (Path[])Files.list(dir2).sorted(Comparator.comparing(Path::getFileName)).toArray(Path[]::new)).length) {
            return false;
        }
        for (int i = 0; i < list1.length; ++i) {
            Path path1 = list1[i];
            Path path2 = list2[i];
            if (!path1.getFileName().toString().equals(path2.getFileName().toString())) {
                return false;
            }
            if (LocalCompare.comparePaths(path1, path2)) continue;
            return false;
        }
        return true;
    }
}

