/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.dbe.common;

import io.r2mo.SourceReflect;
import io.r2mo.dbe.common.DBE;
import io.r2mo.dbe.common.DBETool;
import io.r2mo.typed.common.Pagination;
import io.r2mo.typed.json.JObject;
import io.r2mo.typed.service.ActOperation;
import io.r2mo.typed.service.ActResponse;
import io.r2mo.typed.service.ActState;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public abstract class BaseActOperation<T>
implements ActOperation<T> {
    protected final Class<T> entityCls = SourceReflect.classT0(this.getClass());

    protected abstract DBE<?, T, ?> db();

    public ActResponse<T> create(T entity) {
        Map<String, Object> condition = DBETool.getIdentifier(entity);
        Optional<T> queried = this.db().findOne(condition);
        if (queried.isPresent()) {
            return ActResponse.success201(entity);
        }
        T created = this.db().create(entity);
        return ActResponse.success(created);
    }

    public ActResponse<T> updateById(Serializable id, T entity) {
        Optional<T> queried = this.db().findOne(id);
        if (queried.isPresent()) {
            T updated = this.db().update(entity);
            return ActResponse.success(updated);
        }
        return ActResponse.success204();
    }

    public ActResponse<Boolean> removeById(Serializable id) {
        Optional<T> queried = this.db().findOne(id);
        if (queried.isPresent()) {
            Boolean removed = this.db().removeBy(id);
            return ActResponse.success((Object)removed);
        }
        return ActResponse.of((Object)false, (ActState)ActState.SUCCESS_210_GONE);
    }

    public ActResponse<T> findById(Serializable id) {
        Optional<Object> queried = this.db().findOne(id);
        return queried.map(ActResponse::success).orElseGet(ActResponse::success204);
    }

    public ActResponse<List<T>> findAll(Serializable appId, Serializable tenantId) {
        HashMap<String, Object> condition = new HashMap<String, Object>();
        if (Objects.nonNull(appId)) {
            condition.put("appId", appId);
        }
        if (Objects.nonNull(tenantId)) {
            condition.put("tenantId", tenantId);
        }
        List<T> queried = condition.isEmpty() ? this.db().findAll() : this.db().findMany((Map<String, Object>)condition);
        return ActResponse.success(queried);
    }

    public ActResponse<List<T>> findBy(JObject criteria) {
        List<T> queried = this.db().findMany(criteria);
        return ActResponse.success(queried);
    }

    public ActResponse<Pagination<T>> findPage(JObject query) {
        Pagination<T> queried = this.db().findPage(query);
        return ActResponse.success(queried);
    }

    public ActResponse<List<T>> saveBatch(List<T> entities) {
        if (entities == null || entities.isEmpty()) {
            return ActResponse.of(new ArrayList(), (ActState)ActState.SUCCESS_204_NO_DATA);
        }
        List<T> saved = this.db().save(entities);
        return ActResponse.success(saved);
    }
}

