/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.dbe.common;

import io.r2mo.SourceReflect;
import io.r2mo.typed.annotation.Identifiers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DBETool {
    static <K, T> Map<K, List<T>> groupBy(List<T> entities, String field, Class<T> entityCls) {
        Function<Object, Object> keyMapper = entity -> SourceReflect.value((Object)entity, (String)field, (Class)entityCls);
        return entities.parallelStream().collect(Collectors.groupingBy(keyMapper));
    }

    public static <T> Map<String, Object> getIdentifier(Object entity) {
        if (Objects.isNull(entity)) {
            return null;
        }
        Class<?> entityCls = entity.getClass();
        Identifiers identifiers = entityCls.getDeclaredAnnotation(Identifiers.class);
        if (Objects.isNull(identifiers)) {
            return null;
        }
        HashMap<String, Object> condition = new HashMap<String, Object>();
        String[] fields = identifiers.value();
        Object instance = entity;
        for (String field : fields) {
            condition.put(field, SourceReflect.value((Object)instance, (String)field, entityCls));
        }
        if (identifiers.ifApp()) {
            condition.put("appId", SourceReflect.value((Object)instance, (String)"appId", entityCls));
        }
        if (identifiers.ifTenant()) {
            condition.put("tenantId", SourceReflect.value((Object)instance, (String)"tenantId", entityCls));
        }
        if (identifiers.ifEnabled()) {
            condition.put("enabled", true);
        }
        return condition;
    }
}

