/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.dbe.common;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DBETool {
    static <K, T> Map<K, List<T>> groupBy(List<T> entities, String field, Class<T> entityCls) {
        Function<Object, Object> keyMapper = entity -> DBETool.getValue(entity, field, entityCls);
        return entities.parallelStream().collect(Collectors.groupingBy(keyMapper));
    }

    public static <K, T> K getValue(T entity, String field, Class<T> entityCls) {
        if (entity == null || field == null || field.isEmpty() || entityCls == null) {
            return null;
        }
        try {
            Object value;
            Field f = DBETool.getField(entityCls, field);
            if (f == null) {
                return null;
            }
            f.setAccessible(true);
            Object key = value = f.get(entity);
            return (K)key;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Field getField(Class<?> entityCls, String fieldName) {
        while (entityCls != null && entityCls != Object.class) {
            try {
                return entityCls.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                entityCls = entityCls.getSuperclass();
            }
        }
        return null;
    }
}

