/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.dbe.common;

import io.r2mo.base.dbe.constant.OpType;
import io.r2mo.base.dbe.constant.QCV;
import io.r2mo.base.dbe.operation.OpAggr;
import io.r2mo.base.dbe.operation.OpDb;
import io.r2mo.base.dbe.operation.OpVary;
import io.r2mo.base.dbe.operation.QrAnalyzer;
import io.r2mo.base.dbe.operation.QrMany;
import io.r2mo.base.dbe.operation.QrOne;
import io.r2mo.base.dbe.syntax.QQuery;
import io.r2mo.base.dbe.syntax.QTree;
import io.r2mo.dbe.common.DBEConfiguration;
import io.r2mo.dbe.common.DBETool;
import io.r2mo.typed.cc.Cc;
import io.r2mo.typed.json.JObject;
import io.r2mo.typed.process.Pagination;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DBE<QR, T, EXECUTOR>
extends DBEConfiguration {
    private static final Cc<String, DBE<?, ?, ?>> CCT_DBE = Cc.openThread();
    private final Class<T> entityCls;
    private final EXECUTOR executor;
    private final OpAggr opAggr;
    private final OpDb<T> opDb;
    private final QrOne<T> qrOne;
    private final QrMany<T> qrMany;
    private final OpVary<T, QR> opVary;
    private final QrAnalyzer<QR> qrAnalyzer;

    protected DBE(Class<T> entityCls, EXECUTOR executor) {
        this.entityCls = entityCls;
        this.executor = executor;
        this.opAggr = SPI_DB.opAggr(entityCls, executor);
        this.qrOne = SPI_DB.qrOne(entityCls, executor);
        this.qrMany = SPI_DB.qrMany(entityCls, executor);
        this.opDb = SPI_DB.opDb(entityCls, executor);
        this.opVary = SPI_DB.opVary(entityCls, executor);
        this.qrAnalyzer = SPI_DB.qrAnalyzer(entityCls, executor);
    }

    public static <QR, T, EXECUTOR, R extends DBE<QR, T, EXECUTOR>> R of(Class<T> entityCls, EXECUTOR executor) {
        Objects.requireNonNull(entityCls, "[ R2MO ] \u53c2\u6570 entityCls \u4e0d\u80fd\u4e3a\u7a7a");
        Objects.requireNonNull(executor, "[ R2MO ] \u53c2\u6570 executor \u4e0d\u80fd\u4e3a\u7a7a");
        String cacheKey = entityCls.getName() + "@" + executor.hashCode();
        return (R)((DBE)CCT_DBE.pick(() -> new DBE(entityCls, executor), (Object)cacheKey));
    }

    protected EXECUTOR executor() {
        return this.executor;
    }

    protected Class<T> entityCls() {
        return this.entityCls;
    }

    public Optional<Long> count(String field, Object value) {
        return this.opAggr.execute(null, Long.class, QCV.Aggr.COUNT, field, value);
    }

    public Optional<Long> count(QTree criteria) {
        return this.opAggr.execute(null, Long.class, QCV.Aggr.COUNT, criteria);
    }

    public Optional<Long> count(JObject criteriaJ) {
        return this.count(QTree.of((JObject)criteriaJ));
    }

    public Optional<BigDecimal> sum(String aggrField, String field, Object value) {
        return this.opAggr.execute(aggrField, BigDecimal.class, QCV.Aggr.SUM, field, value);
    }

    public Optional<BigDecimal> sum(String aggrField, QTree criteria) {
        return this.opAggr.execute(aggrField, BigDecimal.class, QCV.Aggr.SUM, criteria);
    }

    public Optional<BigDecimal> sum(String aggrField, JObject criteriaJ) {
        return this.sum(aggrField, QTree.of((JObject)criteriaJ));
    }

    public Optional<BigDecimal> avg(String aggrField, String field, Object value) {
        return this.opAggr.execute(aggrField, BigDecimal.class, QCV.Aggr.AVG, field, value);
    }

    public Optional<BigDecimal> avg(String aggrField, QTree criteria) {
        return this.opAggr.execute(aggrField, BigDecimal.class, QCV.Aggr.AVG, criteria);
    }

    public Optional<BigDecimal> avg(String aggrField, JObject criteriaJ) {
        return this.avg(aggrField, QTree.of((JObject)criteriaJ));
    }

    public Optional<BigDecimal> min(String aggrField, String field, Object value) {
        return this.opAggr.execute(aggrField, BigDecimal.class, QCV.Aggr.MIN, field, value);
    }

    public Optional<BigDecimal> min(String aggrField, QTree criteria) {
        return this.opAggr.execute(aggrField, BigDecimal.class, QCV.Aggr.MIN, criteria);
    }

    public Optional<BigDecimal> min(String aggrField, JObject criteriaJ) {
        return this.min(aggrField, QTree.of((JObject)criteriaJ));
    }

    public Optional<BigDecimal> max(String aggrField, String field, Object value) {
        return this.opAggr.execute(aggrField, BigDecimal.class, QCV.Aggr.MAX, field, value);
    }

    public Optional<BigDecimal> max(String aggrField, QTree criteria) {
        return this.opAggr.execute(aggrField, BigDecimal.class, QCV.Aggr.MAX, criteria);
    }

    public Optional<BigDecimal> max(String aggrField, JObject criteriaJ) {
        return this.max(aggrField, QTree.of((JObject)criteriaJ));
    }

    public Optional<T> findOne(Serializable id) {
        return this.qrOne.execute(id);
    }

    public Optional<T> findOne(String field, Object value) {
        return this.qrOne.execute(field, value);
    }

    public Optional<T> findOne(QTree criteria) {
        return this.qrOne.execute(criteria);
    }

    public Optional<T> findOne(JObject criteriaJ) {
        return this.findOne(QTree.of((JObject)criteriaJ));
    }

    public List<T> findMany(Serializable ... ids) {
        return this.qrMany.execute(ids);
    }

    public List<T> findMany(String field, Object value) {
        return this.qrMany.execute(field, value);
    }

    public List<T> findMany(QTree criteria) {
        return this.qrMany.execute(criteria);
    }

    public List<T> findMany(JObject criteriaJ) {
        return this.findMany(QTree.of((JObject)criteriaJ));
    }

    public List<T> findFull(QQuery query) {
        return this.qrMany.execute(query);
    }

    public List<T> findFull(JObject queryJ) {
        return this.findFull(QQuery.of((JObject)queryJ));
    }

    public Pagination<T> findPage(QQuery query) {
        return this.opVary.queryPage(query);
    }

    public Pagination<T> findPage(JObject queryJ) {
        return this.findPage(QQuery.of((JObject)queryJ));
    }

    public <K> Map<K, List<T>> findGroupBy(QTree criteria, String groupBy) {
        List<T> entities = this.findMany(criteria);
        return DBETool.groupBy(entities, groupBy, this.entityCls);
    }

    public <K> Map<K, List<T>> findGroupBy(JObject criteriaJ, String groupBy) {
        return this.findGroupBy(QTree.of((JObject)criteriaJ), groupBy);
    }

    public <K> Map<K, List<T>> findGroupBy(String field, Object value, String groupBy) {
        List<T> entities = this.findMany(field, value);
        return DBETool.groupBy(entities, groupBy, this.entityCls);
    }

    public List<T> findMap(Map<String, Object> map) {
        Object condition = this.qrAnalyzer.where(map);
        return this.opVary.queryMany(condition);
    }

    public List<T> findMap(JObject mapJ) {
        return this.findMap(mapJ.toMap());
    }

    public List<T> findManyIn(String field, Object ... values) {
        Object condition = this.qrAnalyzer.whereIn(field, values);
        return this.opVary.queryMany(condition);
    }

    public List<T> findManyIn(String field, List<?> values) {
        return this.findManyIn(field, values.toArray());
    }

    public T create(T entity) {
        return (T)this.opDb.execute(entity, OpType.CREATE);
    }

    public List<T> create(List<T> entities, int batchSize) {
        return this.opDb.execute(entities, OpType.CREATE, batchSize);
    }

    public List<T> create(List<T> entities) {
        return this.create(entities, this.pBatchSize());
    }

    public T update(T entity) {
        return (T)this.opDb.execute(entity, OpType.UPDATE);
    }

    public List<T> update(List<T> entities, int batchSize) {
        return this.opDb.execute(entities, OpType.UPDATE, batchSize);
    }

    public List<T> update(List<T> entities) {
        return this.update(entities, this.pBatchSize());
    }

    public T save(T entity) {
        return (T)this.opDb.execute(entity, OpType.SAVE);
    }

    public List<T> save(List<T> entities, int batchSize) {
        return this.opDb.execute(entities, OpType.SAVE, batchSize);
    }

    public List<T> save(List<T> entities) {
        return this.save(entities, this.pBatchSize());
    }

    public T remove(T entity) {
        return (T)this.opDb.execute(entity, OpType.REMOVE);
    }

    public List<T> remove(List<T> entities, int batchSize) {
        return this.opDb.execute(entities, OpType.REMOVE, batchSize);
    }

    public List<T> remove(List<T> entities) {
        return this.remove(entities, this.pBatchSize());
    }

    public boolean removeBy(Serializable id) {
        return this.opVary.removeById(id);
    }

    public boolean removeBy(String field, Object value) {
        Object condition = this.qrAnalyzer.where(field, value);
        return this.opVary.removeBy(condition);
    }

    public boolean removeBy(QTree criteria) {
        Object condition = this.qrAnalyzer.where(criteria);
        return this.opVary.removeBy(condition);
    }

    public boolean removeBy(JObject criteriaJ) {
        return this.removeBy(QTree.of((JObject)criteriaJ));
    }

    public T updateBy(Serializable id, T latest) {
        return (T)this.opVary.update(this.findOne(id), latest);
    }

    public T updateBy(String field, Object value, T latest) {
        return (T)this.opVary.update(this.findOne(field, value), latest);
    }

    public T updateBy(QTree criteria, T latest) {
        return (T)this.opVary.update(this.findOne(criteria), latest);
    }

    public T updateBy(JObject criteriaJ, T latest) {
        return this.updateBy(QTree.of((JObject)criteriaJ), latest);
    }

    public T saveBy(Serializable id, T latest) {
        return (T)this.opVary.save(this.findOne(id), latest);
    }

    public T saveBy(String field, Object value, T latest) {
        return (T)this.opVary.save(this.findOne(field, value), latest);
    }

    public T saveBy(QTree criteria, T latest) {
        return (T)this.opVary.save(this.findOne(criteria), latest);
    }

    public T saveBy(JObject criteriaJ, T latest) {
        return this.saveBy(QTree.of((JObject)criteriaJ), latest);
    }
}

