/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.dbe.mybatisplus.spi;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.yulichang.query.MPJQueryWrapper;
import io.r2mo.base.dbe.common.DBNode;
import io.r2mo.base.dbe.common.DBRef;
import io.r2mo.base.dbe.operation.QrAnalyzer;
import io.r2mo.base.dbe.syntax.QLeaf;
import io.r2mo.base.dbe.syntax.QNode;
import io.r2mo.base.dbe.syntax.QPager;
import io.r2mo.base.dbe.syntax.QQuery;
import io.r2mo.base.dbe.syntax.QSorter;
import io.r2mo.base.dbe.syntax.QTree;
import io.r2mo.base.dbe.syntax.QValue;
import io.r2mo.dbe.mybatisplus.spi.MetaFix;
import io.r2mo.typed.common.Kv;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QrAnalyzerJoin<T>
implements QrAnalyzer<MPJQueryWrapper<T>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QrAnalyzerJoin.class);
    private final DBRef ref;

    public QrAnalyzerJoin(DBRef ref) {
        this.ref = ref;
    }

    public MPJQueryWrapper<T> whereIn(String field, Object ... values) {
        QValue qValue = QValue.of((String)field, (Object)values);
        String column = this.ref.seekColumn(qValue.field());
        MPJQueryWrapper<T> condition = this.waitForQuery();
        condition.in((Object)column, MetaFix.toCollection(values));
        return condition;
    }

    public MPJQueryWrapper<T> whereId(Serializable id) {
        MPJQueryWrapper<T> condition = this.waitForQuery();
        DBNode node = this.ref.find();
        String tableAlias = this.ref.seekAlias(node.entity());
        Kv kv = this.ref.find().key();
        condition.eq((Object)(tableAlias + "." + (String)kv.key()), (Object)id);
        return condition;
    }

    public MPJQueryWrapper<T> where(Map<String, Object> map) {
        if (Objects.isNull(map) || map.isEmpty()) {
            return this.waitForQuery();
        }
        MPJQueryWrapper<T> condition = this.waitForQuery();
        map.forEach((field, value) -> {
            QValue leaf = QValue.of((String)field, (Object)value);
            condition.and(arg_0 -> this.lambda$where$0((QLeaf)leaf, arg_0));
        });
        return condition;
    }

    public MPJQueryWrapper<T> where(String field, Object value) {
        QValue qValue = QValue.of((String)field, (Object)value);
        MPJQueryWrapper<T> condition = this.waitForQuery();
        this.whereLeaf((QLeaf)qValue, condition);
        return condition;
    }

    public MPJQueryWrapper<T> where(QTree tree, QSorter sorter) {
        if (Objects.isNull(tree)) {
            return null;
        }
        MPJQueryWrapper<T> condition = this.waitForQuery();
        QNode node = tree.item();
        this.whereTree(node, condition);
        this.orderBy(condition, sorter);
        return condition;
    }

    public MPJQueryWrapper<T> where(QQuery query) {
        Objects.requireNonNull(query);
        MPJQueryWrapper<T> condition = this.where(query.criteria(), query.sorter());
        MetaFix.filterBy(condition, query.projection(), arg_0 -> ((DBRef)this.ref).seekColumn(arg_0));
        return condition;
    }

    public IPage<Map<String, Object>> page(QQuery query) {
        if (Objects.isNull(query)) {
            return null;
        }
        QPager pager = query.pager();
        if (Objects.isNull(pager)) {
            return null;
        }
        return new Page((long)pager.getPage(), (long)pager.getSize());
    }

    private MPJQueryWrapper<T> waitForQuery() {
        MPJQueryWrapper query = new MPJQueryWrapper();
        DBNode first = this.ref.find();
        DBNode second = this.ref.findSecond();
        String firstAlias = this.ref.seekAlias(first.entity());
        query.setAlias(firstAlias);
        String secondAlias = this.ref.seekAlias(second.entity());
        Set joinOn = this.ref.seekJoinOn(second.entity());
        StringBuilder joinStr = new StringBuilder();
        joinStr.append(second.table()).append(" AS ").append(secondAlias).append(" ON (");
        ArrayList onList = new ArrayList();
        joinOn.forEach(vector -> {
            String fieldJoin = (String)vector.key();
            String field = (String)vector.value();
            String columnJoin = second.vColumn(fieldJoin);
            String column = first.vColumn(field);
            onList.add(secondAlias + "." + columnJoin + " = " + firstAlias + "." + column);
        });
        joinStr.append(String.join((CharSequence)" AND ", onList));
        joinStr.append(")");
        log.info("[ R2MO ] \u6784\u5efa MPJ / JOIN \u8bed\u53e5: \ud83c\udf9f\ufe0f `{}`", (Object)joinStr);
        query.leftJoin(joinStr.toString());
        return query;
    }

    private void whereTree(QNode node, MPJQueryWrapper<T> query) {
        MetaFix.whereTree(node, query, leaf -> this.ref.seekColumn(leaf.field()));
    }

    private void whereLeaf(QLeaf node, MPJQueryWrapper<T> query) {
        MetaFix.whereLeaf(node, query, leaf -> this.ref.seekColumn(leaf.field()));
    }

    private void orderBy(MPJQueryWrapper<T> query, QSorter sorter) {
        MetaFix.orderBy(query, sorter, arg_0 -> ((DBRef)this.ref).seekColumn(arg_0));
    }

    private /* synthetic */ void lambda$where$0(QLeaf leaf, MPJQueryWrapper w) {
        this.whereLeaf(leaf, w);
    }
}

