/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.dbe.mybatisplus.spi;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.r2mo.base.dbe.common.DBLoad;
import io.r2mo.base.dbe.common.DBNode;
import io.r2mo.base.dbe.operation.QrAnalyzer;
import io.r2mo.base.dbe.syntax.QLeaf;
import io.r2mo.base.dbe.syntax.QNode;
import io.r2mo.base.dbe.syntax.QPager;
import io.r2mo.base.dbe.syntax.QQuery;
import io.r2mo.base.dbe.syntax.QSorter;
import io.r2mo.base.dbe.syntax.QTree;
import io.r2mo.base.dbe.syntax.QValue;
import io.r2mo.dbe.mybatisplus.spi.MetaFix;
import io.r2mo.spi.SPI;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;

class QrAnalyzerImpl<T>
implements QrAnalyzer<QueryWrapper<T>> {
    private final Class<T> entityCls;
    private final DBNode node;

    QrAnalyzerImpl(Class<T> entityCls) {
        this.entityCls = entityCls;
        DBLoad loader = SPI.SPI_DB.loader();
        this.node = loader.configure(entityCls);
    }

    public QueryWrapper<T> whereIn(String field, Object ... values) {
        QValue qValue = QValue.of((String)field, (Object)values);
        String column = this.node.vColumn(qValue.field());
        return (QueryWrapper)Wrappers.query(this.entityCls).in((Object)column, Arrays.asList(values));
    }

    public QueryWrapper<T> where(String field, Object value) {
        QValue qValue = QValue.of((String)field, (Object)value);
        QueryWrapper condition = Wrappers.query(this.entityCls);
        this.whereLeaf((QLeaf)qValue, condition);
        return condition;
    }

    public QueryWrapper<T> where(Map<String, Object> map) {
        if (Objects.isNull(map) || map.isEmpty()) {
            return Wrappers.query();
        }
        QueryWrapper condition = Wrappers.query(this.entityCls);
        map.forEach((field, value) -> {
            QValue leaf = QValue.of((String)field, (Object)value);
            condition.and(arg_0 -> this.lambda$where$0((QLeaf)leaf, arg_0));
        });
        return condition;
    }

    public QueryWrapper<T> where(QTree tree, QSorter sorter) {
        if (Objects.isNull(tree)) {
            return null;
        }
        QueryWrapper condition = Wrappers.query(this.entityCls);
        QNode root = tree.item();
        this.whereTree(root, condition);
        this.orderBy(condition, sorter);
        return condition;
    }

    public QueryWrapper<T> where(QQuery query) {
        Objects.requireNonNull(query);
        QueryWrapper<T> condition = this.where(query.criteria(), query.sorter());
        MetaFix.filterBy(condition, query.projection(), arg_0 -> ((DBNode)this.node).vColumn(arg_0));
        return condition;
    }

    public IPage<T> page(QQuery query) {
        if (Objects.isNull(query)) {
            return null;
        }
        QPager pager = query.pager();
        if (Objects.isNull(pager)) {
            return null;
        }
        return new Page((long)pager.getPage(), (long)pager.getSize());
    }

    private void whereTree(QNode node, QueryWrapper<T> query) {
        MetaFix.whereTree(node, query, leaf -> this.node.vColumn(leaf.field()));
    }

    private void whereLeaf(QLeaf node, QueryWrapper<T> query) {
        MetaFix.whereLeaf(node, query, leaf -> this.node.vColumn(leaf.field()));
    }

    private void orderBy(QueryWrapper<T> query, QSorter sorter) {
        MetaFix.orderBy(query, sorter, arg_0 -> ((DBNode)this.node).vColumn(arg_0));
    }

    private /* synthetic */ void lambda$where$0(QLeaf leaf, QueryWrapper w) {
        this.whereLeaf(leaf, w);
    }
}

