/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.dbe.mybatisplus.spi;

import com.github.yulichang.base.MPJBaseMapper;
import io.r2mo.base.dbe.common.DBFor;
import io.r2mo.base.dbe.common.DBNode;
import io.r2mo.base.dbe.common.DBRef;
import io.r2mo.base.dbe.common.DBResult;
import io.r2mo.dbe.common.DBEWait;
import io.r2mo.dbe.mybatisplus.JoinProxy;
import io.r2mo.dbe.mybatisplus.core.domain.BaseEntity;
import io.r2mo.typed.exception.web._501NotSupportException;
import io.r2mo.typed.json.JObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OpJoinWriter<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpJoinWriter.class);
    private final JoinProxy<T> executor;
    private final DBRef ref;
    private boolean isReady = false;

    OpJoinWriter(DBRef ref, JoinProxy<T> executor) {
        this.ref = ref;
        this.executor = executor;
    }

    private JoinProxy<T> executor() {
        if (this.isReady) {
            return this.executor;
        }
        Set entitySet = this.ref.findJoined();
        this.isReady = entitySet.stream().anyMatch(this.executor::isReady);
        if (!this.isReady) {
            throw new _501NotSupportException("[ R2MO ] \u7531\u4e8e\u6267\u884c\u5668\u4e0d\u5b8c\u6574\uff0cJOIN \u6a21\u5f0f\u7684\u5199\u64cd\u4f5c\u65e0\u6cd5\u6267\u884c\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u4e3a\u6240\u6709\u7684\u5b9e\u4f53\u90fd\u914d\u7f6e\u4e86\u5bf9\u5e94\u7684\u6267\u884c\u5668\uff01");
        }
        return this.executor;
    }

    public JObject create(JObject request) {
        DBNode first = this.ref.findPrimary();
        Object waitFor = DBEWait.of((DBRef)this.ref).build(request, first);
        MPJBaseMapper<?> mapper = this.executor().mapper(first.entity());
        int rows = mapper.insert(waitFor);
        this.cleanExtension(waitFor);
        HashSet childSet = new HashSet();
        this.ref.findByExclude(first.entity()).forEach(standBy -> {
            Object waitMinor = DBEWait.of((DBRef)this.ref).build(request, standBy, waitFor);
            MPJBaseMapper<?> minorMapper = this.executor().mapper(standBy.entity());
            int minorRows = minorMapper.insert(waitMinor);
            log.info("[ R2MO ] \u4e3b\u5b9e\u4f53 {} / \u8f85\u52a9\u5b9e\u4f53 {}", (Object)rows, (Object)minorRows);
            this.cleanExtension(waitMinor);
            childSet.add(waitMinor);
        });
        return DBResult.of((DBRef)this.ref).build(waitFor, childSet, first);
    }

    public Boolean removeBy(JObject removedJ) {
        DBNode first = this.ref.findPrimary();
        this.ref.findByExclude(first.entity()).forEach(standBy -> this.removeBy(removedJ, (DBNode)standBy));
        this.removeBy(removedJ, first);
        return true;
    }

    private void removeBy(JObject removedJ, DBNode node) {
        MPJBaseMapper<?> mapper = this.executor().mapper(node.entity());
        JObject condition = DBFor.ofRemove().exchange(removedJ, node, this.ref);
        mapper.deleteByMap(condition.toMap());
    }

    public JObject update(JObject updatedJ) {
        DBNode first = this.ref.findPrimary();
        Object waitFor = DBEWait.of((DBRef)this.ref).build(updatedJ, first);
        MPJBaseMapper<?> mapper = this.executor().mapper(first.entity());
        int rows = mapper.updateById(waitFor);
        this.cleanExtension(waitFor);
        HashSet childSet = new HashSet();
        this.ref.findByExclude(first.entity()).forEach(standBy -> {
            Object waitMinor = DBEWait.of((DBRef)this.ref).build(updatedJ, standBy, waitFor);
            MPJBaseMapper<?> minorMapper = this.executor().mapper(standBy.entity());
            int minorRows = minorMapper.updateById(waitMinor);
            log.info("[ R2MO ] \u4e3b\u5b9e\u4f53 {} / \u8f85\u52a9\u5b9e\u4f53 {}", (Object)rows, (Object)minorRows);
            this.cleanExtension(waitMinor);
            childSet.add(waitMinor);
        });
        return DBResult.of((DBRef)this.ref).build(waitFor, childSet, first);
    }

    private void cleanExtension(Object waitFor) {
        if (waitFor instanceof BaseEntity) {
            BaseEntity waitForClean = (BaseEntity)waitFor;
            waitForClean.setExtension(Map.of());
        }
    }
}

