/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.dbe.mybatisplus.spi;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import io.r2mo.SourceReflect;
import io.r2mo.base.dbe.constant.OpType;
import io.r2mo.base.dbe.operation.OpDb;
import io.r2mo.dbe.common.operation.AbstractDbOperation;
import io.r2mo.dbe.mybatisplus.core.domain.BaseEntity;
import io.r2mo.dbe.mybatisplus.spi.MetaObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.ibatis.executor.BatchResult;

class OpDbImpl<T, M extends BaseMapper<T>>
extends AbstractDbOperation<QueryWrapper<T>, T, M>
implements OpDb<T> {
    OpDbImpl(Class<T> entityCls, M m) {
        super(entityCls, m);
    }

    public T execute(T entity, OpType opType) {
        if (Objects.isNull(entity)) {
            return null;
        }
        MetaObject.insert(entity, opType);
        switch (opType) {
            case CREATE: {
                ((BaseMapper)this.executor()).insert(entity);
                break;
            }
            case UPDATE: {
                ((BaseMapper)this.executor()).updateById(entity);
                break;
            }
            case REMOVE: {
                ((BaseMapper)this.executor()).deleteById(entity);
                break;
            }
            case SAVE: {
                ((BaseMapper)this.executor()).insertOrUpdate(entity);
            }
        }
        return entity;
    }

    public List<T> execute(List<T> entities, OpType opType, int batchSize) {
        if (Objects.isNull(entities) || entities.isEmpty()) {
            return new ArrayList();
        }
        MetaObject.insert(entities, opType);
        return switch (opType) {
            default -> throw new IncompatibleClassChangeError();
            case OpType.CREATE -> this.buildResult(((BaseMapper)this.executor()).insert(entities, batchSize));
            case OpType.UPDATE -> this.buildResult(((BaseMapper)this.executor()).updateById(entities, batchSize));
            case OpType.REMOVE -> this.batchRemove(entities);
            case OpType.SAVE -> this.buildResult(((BaseMapper)this.executor()).insertOrUpdate(entities, batchSize));
        };
    }

    private List<T> batchRemove(List<T> entities) {
        ArrayList<Object> ids = new ArrayList<Object>();
        for (T entity : entities) {
            Object value;
            if (entity instanceof BaseEntity) {
                BaseEntity baseEntity = (BaseEntity)entity;
                ids.add(baseEntity.getId());
                continue;
            }
            Field field = SourceReflect.fieldN((Class)this.entityCls(), (String)"id");
            if (Objects.isNull(field) || !Objects.nonNull(value = SourceReflect.value(entity, (String)field.getName(), (Class)this.entityCls()))) continue;
            ids.add(value);
        }
        ((BaseMapper)this.executor()).deleteByIds(ids);
        return entities;
    }

    private List<T> buildResult(List<BatchResult> batchResults) {
        ArrayList results = new ArrayList();
        batchResults.stream().filter(item -> !item.getParameterObjects().isEmpty()).map(item -> item.getParameterObjects().get(0)).map(item -> item).forEach(results::add);
        return results;
    }
}

