/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.dbe.mybatisplus.core.domain;

import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import io.r2mo.dbe.mybatisplus.core.domain.BaseEntity;
import io.r2mo.spi.SPI;
import io.r2mo.typed.domain.ContextOr;
import io.r2mo.typed.domain.extension.AbstractNormObject;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseProp {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseProp.class);

    private BaseProp() {
    }

    public static void setCommon(BaseEntity baseEntity) {
        if (Objects.isNull(baseEntity)) {
            log.warn("[ R2MO ] - setCommon(BaseEntity): \u4f20\u5165\u5b9e\u4f53\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u5e38\u89c4\u5b57\u6bb5 \n --> version, enabled, language, cMetadata");
            return;
        }
        baseEntity.setVersion("1.0.0");
        baseEntity.setEnabled(Boolean.TRUE);
        baseEntity.setLanguage("zh-CN");
        baseEntity.setCMetadata(SPI.J());
    }

    public static void setScope(BaseEntity baseEntity, ContextOr context) {
        if (Objects.isNull(baseEntity) || Objects.isNull(context)) {
            log.warn("[ R2MO ] - setScope(BaseEntity, ContextOr): \u4f20\u5165\u5b9e\u4f53\u6216\u4e0a\u4e0b\u6587\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u8303\u56f4\u5b57\u6bb5 \n --> appId, tenantId");
            return;
        }
        baseEntity.setAppId((UUID)context.idApp(true));
        baseEntity.setTenantId((UUID)context.idTenant(true));
    }

    public static void setAudit(BaseEntity baseEntity, UUID userId, boolean created) {
        if (Objects.isNull(baseEntity)) {
            log.warn("[ R2MO ] - setAudit(BaseEntity, UUID, boolean): \u4f20\u5165\u5b9e\u4f53\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u5ba1\u8ba1\u5b57\u6bb5 \n --> createdBy, createdAt, updatedBy, updatedAt");
            return;
        }
        LocalDateTime executeAt = LocalDateTime.now();
        if (Objects.nonNull(userId)) {
            baseEntity.setUpdatedBy(userId);
        }
        baseEntity.setUpdatedAt(executeAt);
        if (created) {
            if (Objects.nonNull(userId)) {
                baseEntity.setCreatedBy(userId);
            }
            baseEntity.setCreatedAt(executeAt);
        }
    }

    public static void setAudit(BaseEntity baseEntity, String userId, boolean created) {
        if (Objects.isNull(userId)) {
            BaseProp.setAudit(baseEntity, (UUID)null, created);
        } else {
            BaseProp.setAudit(baseEntity, UUID.fromString(userId), created);
        }
    }

    public static void setCode(BaseEntity baseEntity) {
        if (Objects.isNull(baseEntity)) {
            log.warn("[ R2MO ] - setCode(BaseEntity): \u4f20\u5165\u5b9e\u4f53\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8bbe\u7f6e Code \u5b57\u6bb5 \n --> code");
            return;
        }
        String code = baseEntity.getCode();
        if (StrUtil.isEmpty((CharSequence)code)) {
            baseEntity.setCode(RandomUtil.randomString((int)16));
        }
    }

    public static void copyScope(BaseEntity target, BaseEntity source) {
        if (Objects.isNull(target) || Objects.isNull(source)) {
            log.warn(" [ R2MO ] - copyScope(BaseEntity, BaseEntity): \u4f20\u5165\u5b9e\u4f53\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u62f7\u8d1d\u8303\u56f4\u5b57\u6bb5 \n --> appId, tenantId");
            return;
        }
        target.setAppId(source.getAppId());
        target.setTenantId(source.getTenantId());
    }

    public static void copyScope(AbstractNormObject target, BaseEntity source) {
        if (Objects.isNull(target) || Objects.isNull(source)) {
            log.warn(" [ R2MO ] - copyScope(AbstractNormObject, BaseEntity): \u4f20\u5165\u5b9e\u4f53\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u62f7\u8d1d\u8303\u56f4\u5b57\u6bb5 \n --> appId, tenantId");
            return;
        }
        target.setAppId(source.getAppId());
        target.setTenantId(source.getTenantId());
    }

    public static void copyAudit(BaseEntity target, BaseEntity source) {
        if (Objects.isNull(target) || Objects.isNull(source)) {
            log.warn(" [ R2MO ] - copyAudit(BaseEntity, BaseEntity): \u4f20\u5165\u5b9e\u4f53\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u62f7\u8d1d\u5ba1\u8ba1\u5b57\u6bb5 \n --> createdBy, createdAt, updatedBy, updatedAt");
            return;
        }
        target.setCreatedBy(source.getCreatedBy());
        target.setCreatedAt(source.getCreatedAt());
        target.setUpdatedBy(source.getUpdatedBy());
        target.setUpdatedAt(source.getUpdatedAt());
    }

    public static void copyAudit(AbstractNormObject target, BaseEntity source) {
        if (Objects.isNull(target) || Objects.isNull(source)) {
            log.warn(" [ R2MO ] - copyAudit(AbstractNormObject, BaseEntity): \u4f20\u5165\u5b9e\u4f53\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u62f7\u8d1d\u5ba1\u8ba1\u5b57\u6bb5 \n --> createdBy, createdAt, updatedBy, updatedAt");
            return;
        }
        target.setCreatedBy(source.getCreatedBy());
        target.setCreatedAt(source.getCreatedAt());
        target.setUpdatedBy(source.getUpdatedBy());
        target.setUpdatedAt(source.getUpdatedAt());
    }

    public static void copyFull(BaseEntity target, BaseEntity source) {
        if (Objects.isNull(target) || Objects.isNull(source)) {
            log.warn(" [ R2MO ] - copyFull(BaseEntity, BaseEntity): \u4f20\u5165\u5b9e\u4f53\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u62f7\u8d1d\u5168\u5b57\u6bb5\uff01");
            return;
        }
        target.setLanguage(source.getLanguage());
        target.setVersion(source.getVersion());
        target.setEnabled(source.isEnabled());
        BaseProp.copyAudit(target, source);
        BaseProp.copyScope(target, source);
    }
}

