/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.dbe.mybatisplus.core.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;

class BaseDebug {
    private static final List<String> SPECIAL_FIELDS = Arrays.asList("id", "code", "appId", "tenantId");

    BaseDebug() {
    }

    public static String dgInfo(Object obj) {
        if (obj == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Object@").append(obj.hashCode()).append("\n");
        Class<?> clazz = obj.getClass();
        BaseDebug.appendClassInfo(sb, clazz, obj);
        sb.append("- \u7279\u6b8a\u4fe1\u606f\n");
        BaseDebug.appendSpecialFields(sb, obj);
        return sb.toString();
    }

    private static void appendClassInfo(StringBuilder sb, Class<?> clazz, Object obj) {
        if (clazz.getSuperclass() != null && !clazz.getSuperclass().equals(Object.class)) {
            BaseDebug.appendClassInfo(sb, clazz.getSuperclass(), obj);
        }
        Field[] fields = clazz.getDeclaredFields();
        boolean hasPrintableFields = false;
        for (Field field : fields) {
            if (!BaseDebug.shouldPrintField(field)) continue;
            try {
                field.setAccessible(true);
                if (field.get(obj) == null) continue;
                hasPrintableFields = true;
                break;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (hasPrintableFields) {
            sb.append("- ").append(clazz.getSimpleName()).append(" / ").append(clazz.getName()).append("\n");
            for (Field field : fields) {
                if (!BaseDebug.shouldPrintField(field)) continue;
                try {
                    field.setAccessible(true);
                    Object value = field.get(obj);
                    sb.append("   ").append(field.getName()).append(" = ").append(value).append("\n");
                }
                catch (IllegalAccessException e) {
                    sb.append("   ").append(field.getName()).append(" = <access denied>\n");
                }
            }
        }
    }

    private static boolean shouldPrintField(Field field) {
        return !Modifier.isStatic(field.getModifiers()) && !field.isAnnotationPresent(JsonIgnore.class);
    }

    private static void appendSpecialFields(StringBuilder sb, Object obj) {
        boolean first = true;
        sb.append("   ");
        for (String fieldName : SPECIAL_FIELDS) {
            Object value = BaseDebug.getFieldValue(obj, fieldName);
            if (value == null) continue;
            if (!first) {
                sb.append(", ");
            }
            sb.append(fieldName).append("=").append(value);
            first = false;
        }
        sb.append("\n");
    }

    private static Object getFieldValue(Object obj, String fieldName) {
        for (Class<?> clazz = obj.getClass(); clazz != null && !clazz.equals(Object.class); clazz = clazz.getSuperclass()) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field.get(obj);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                continue;
            }
        }
        return null;
    }
}

