/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.dbe.mybatisplus.spi;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import io.r2mo.base.dbe.constant.QCV;
import io.r2mo.base.dbe.operation.OpAggr;
import io.r2mo.base.dbe.syntax.QTree;
import io.r2mo.dbe.common.operation.AbstractDbOperation;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

class OpAggrImpl<T, M extends BaseMapper<T>>
extends AbstractDbOperation<QueryWrapper<T>, T, M>
implements OpAggr {
    OpAggrImpl(Class<T> entityCls, M mapper) {
        super(entityCls, mapper);
    }

    public <N extends Number> Optional<N> execute(String aggrField, Class<N> returnCls, QCV.Aggr aggr, String field, Object value) {
        QueryWrapper query = (QueryWrapper)this.analyzer().where(field, value);
        return this.execute(aggrField, returnCls, query, aggr);
    }

    public <N extends Number> Optional<N> execute(String aggrField, Class<N> returnCls, QCV.Aggr aggr, QTree criteria) {
        QueryWrapper query = (QueryWrapper)this.analyzer().where(criteria);
        return this.execute(aggrField, returnCls, query, aggr);
    }

    private <N extends Number> Optional<N> execute(String aggrField, Class<N> returnCls, QueryWrapper<T> query, QCV.Aggr aggr) {
        if (Objects.isNull(aggr)) {
            return Optional.empty();
        }
        if (QCV.Aggr.COUNT == aggr) {
            return this.buildResult(((BaseMapper)this.executor()).selectCount(query), returnCls);
        }
        Objects.requireNonNull(aggrField);
        String fieldSelect = this.buildAggr(aggrField, aggr);
        query.select((Object[])new String[]{fieldSelect});
        List retultList = ((BaseMapper)this.executor()).selectObjs(query);
        if (retultList.isEmpty()) {
            return Optional.empty();
        }
        Object ret = retultList.get(0);
        return this.buildResult(ret, returnCls);
    }

    private <N extends Number> Optional<N> buildResult(Object ret, Class<N> targetClass) {
        if (Objects.isNull(ret)) {
            return Optional.empty();
        }
        if (ret instanceof Long) {
            Long retLong = (Long)ret;
            if (Long.class == targetClass) {
                return Optional.of(retLong);
            }
        }
        String str = ret.toString();
        Number retN = targetClass == Byte.class || targetClass == Byte.TYPE ? (Number)Byte.valueOf(str) : (Number)(targetClass == Short.class || targetClass == Short.TYPE ? (Number)Short.valueOf(str) : (Number)(targetClass == Integer.class || targetClass == Integer.TYPE ? (Number)Integer.valueOf(str) : (Number)(targetClass == Long.class || targetClass == Long.TYPE ? (Number)Long.valueOf(str) : (Number)(targetClass == Float.class || targetClass == Float.TYPE ? (Number)Float.valueOf(str) : (Number)(targetClass == Double.class || targetClass == Double.TYPE ? (Number)Double.valueOf(str) : (Number)(targetClass == BigDecimal.class ? new BigDecimal(str) : (targetClass == BigInteger.class ? new BigInteger(str) : null)))))));
        return Optional.ofNullable(retN);
    }

    private String buildAggr(String fieldAggr, QCV.Aggr aggr) {
        return switch (aggr) {
            default -> throw new IncompatibleClassChangeError();
            case QCV.Aggr.COUNT -> "COUNT(" + fieldAggr + ")";
            case QCV.Aggr.SUM -> "SUM(" + fieldAggr + ")";
            case QCV.Aggr.AVG -> "AVG(" + fieldAggr + ")";
            case QCV.Aggr.MAX -> "MAX(" + fieldAggr + ")";
            case QCV.Aggr.MIN -> "MIN(" + fieldAggr + ")";
        };
    }
}

