/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.dbe.mybatisplus.generator.field;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.r2mo.base.generator.GenConfig;
import io.r2mo.base.generator.GenField;
import io.swagger.v3.oas.annotations.media.Schema;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GenFieldMybatisPlus
implements GenField {
    private static final Set<String> DEFAULT_REQ_IGNORE = Set.of("createdAt", "createdBy", "updatedAt", "updatedBy", "language", "version", "cMetadata", "appId", "tenantId");
    private static final Set<String> DEFAULT_RESP_IGNORE = Set.of("language", "version", "cMetadata", "appId", "tenantId");

    public String generateReq(Class<?> entity, GenConfig config) {
        HashSet<String> ignoreSet = new HashSet<String>(DEFAULT_REQ_IGNORE);
        Set customIgnore = config.getMetadata().getIgnoreReq();
        if (customIgnore != null) {
            ignoreSet.addAll(customIgnore);
        }
        return this.generate(entity, ignoreSet);
    }

    public String generateResp(Class<?> entity, GenConfig config) {
        HashSet<String> ignoreSet = new HashSet<String>(DEFAULT_RESP_IGNORE);
        Set customIgnore = config.getMetadata().getIgnoreResp();
        if (customIgnore != null) {
            ignoreSet.addAll(customIgnore);
        }
        return this.generate(entity, ignoreSet);
    }

    private String generate(Class<?> entity, Set<String> ignoreSet) {
        ArrayList lines = new ArrayList();
        Field[] fields = entity.getDeclaredFields();
        Arrays.stream(fields).filter(field -> !ignoreSet.contains(field.getName())).filter(this::isValid).forEach(field -> lines.addAll(this.buildLines((Field)field)));
        return String.join((CharSequence)"\n", lines);
    }

    public String generateEnum(Class<?> entity) {
        ArrayList lines = new ArrayList();
        Field[] fields = entity.getDeclaredFields();
        Arrays.stream(fields).filter(this::isValid).filter(field -> field.getType().isEnum()).forEach(field -> lines.add("import " + field.getType().getName() + ";"));
        return String.join((CharSequence)"\n", lines);
    }

    private boolean isValid(Field field) {
        if (Modifier.isStatic(field.getModifiers())) {
            return false;
        }
        if (field.isAnnotationPresent(JsonIgnore.class)) {
            return false;
        }
        TableField tableField = field.getDeclaredAnnotation(TableField.class);
        return tableField == null || tableField.exist();
    }

    private List<String> buildLines(Field field) {
        ArrayList<String> lines = new ArrayList<String>();
        Schema schema = field.getAnnotation(Schema.class);
        StringBuilder lineSwagger = new StringBuilder();
        if (schema != null) {
            lineSwagger.append("@Schema(");
            if (!schema.description().isBlank()) {
                lineSwagger.append("description = \"").append(schema.description()).append("\"");
            }
            if (!schema.name().isBlank()) {
                if (lineSwagger.length() > 7) {
                    lineSwagger.append(", ");
                }
                lineSwagger.append("name = \"").append(schema.name()).append("\"");
            }
            lineSwagger.append(")");
            lines.add(lineSwagger.toString());
        }
        lines.add("    private " + field.getType().getSimpleName() + " " + field.getName() + ";");
        return lines;
    }
}

