/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.dbe.mybatisplus.spi;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.github.yulichang.base.MPJBaseMapper;
import com.github.yulichang.query.MPJQueryWrapper;
import io.r2mo.base.dbe.common.DBAlias;
import io.r2mo.base.dbe.common.DBFor;
import io.r2mo.base.dbe.common.DBNode;
import io.r2mo.base.dbe.common.DBRef;
import io.r2mo.base.dbe.common.DBResult;
import io.r2mo.base.dbe.operation.OpJoin;
import io.r2mo.base.dbe.syntax.QQuery;
import io.r2mo.dbe.mybatisplus.JoinProxy;
import io.r2mo.dbe.mybatisplus.spi.OpJoinWriter;
import io.r2mo.dbe.mybatisplus.spi.QrAnalyzerJoin;
import io.r2mo.spi.SPI;
import io.r2mo.typed.common.Kv;
import io.r2mo.typed.json.JArray;
import io.r2mo.typed.json.JObject;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpJoinImpl<T, M extends MPJBaseMapper<T>>
implements OpJoin<T, MPJQueryWrapper<T>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpJoinImpl.class);
    private final M executor;
    private final QrAnalyzerJoin<T> analyzer;
    private final DBRef ref;
    private OpJoinWriter<T> writer;

    OpJoinImpl(DBRef ref, M executor) {
        this.ref = ref;
        this.executor = executor;
        this.analyzer = new QrAnalyzerJoin(ref);
    }

    public void afterConstruct(JoinProxy<T> joinProxy) {
        this.writer = new OpJoinWriter<T>(this.ref, joinProxy);
    }

    private OpJoinWriter<T> writer() {
        return this.writer;
    }

    public JArray findMany(MPJQueryWrapper<T> queryWrapper) {
        this.postSelect(queryWrapper);
        List rows = this.executor.selectJoinMaps(queryWrapper);
        return DBResult.of((DBRef)this.ref).build(rows);
    }

    public JObject findOne(MPJQueryWrapper<T> queryWrapper) {
        this.postSelect(queryWrapper);
        Map row = this.executor.selectJoinMap(queryWrapper);
        return DBResult.of((DBRef)this.ref).build(row);
    }

    public JObject findPage(QQuery query) {
        MPJQueryWrapper<T> queryWrapper = this.analyzer.where(query);
        this.postSelect(queryWrapper);
        IPage<Map<String, Object>> page = this.analyzer.page(query);
        IPage result = this.executor.selectJoinMapsPage(page, queryWrapper);
        return this.toResponse((IPage<Map<String, Object>>)result);
    }

    public JObject findById(Serializable id) {
        MPJQueryWrapper<T> queryWrapper = this.analyzer.whereId(id);
        this.postSelect(queryWrapper);
        Map row = this.executor.selectJoinMap(queryWrapper);
        return DBResult.of((DBRef)this.ref).build(row);
    }

    public Optional<Long> count(MPJQueryWrapper<T> queryWrapper) {
        return Optional.ofNullable(this.executor.selectJoinCount(queryWrapper));
    }

    public JObject create(JObject latest) {
        return this.writer().create(latest);
    }

    public Boolean removeById(Serializable id) {
        JObject stored = this.findById(id);
        return this.writer().removeBy(stored);
    }

    public Boolean removeBy(MPJQueryWrapper<T> queryWrapper) {
        JObject stored = this.findOne(queryWrapper);
        return this.writer().removeBy(stored);
    }

    public JObject updateById(Serializable id, JObject latest) {
        JObject stored = this.findById(id);
        JObject compressed = DBFor.ofFilter().exchange(latest, this.ref);
        compressed.fieldNames().forEach(field -> stored.put(field, compressed.get(field)));
        return this.writer().update(stored);
    }

    public JObject update(MPJQueryWrapper<T> queryWrapper, JObject latest) {
        JObject stored = this.findOne(queryWrapper);
        JObject compressed = DBFor.ofFilter().exchange(latest, this.ref);
        compressed.fieldNames().forEach(field -> stored.put(field, compressed.get(field)));
        return this.writer().update(stored);
    }

    private JObject toResponse(IPage<Map<String, Object>> page) {
        JObject pageJ = SPI.J();
        pageJ.put("count", (Object)page.getTotal());
        List rows = page.getRecords();
        pageJ.put("list", (Object)DBResult.of((DBRef)this.ref).build(rows));
        return pageJ;
    }

    private void postSelect(MPJQueryWrapper<T> queryWrapper) {
        Set aliasNames;
        StringBuilder selectBuilder = new StringBuilder();
        if (StrUtil.isEmpty((CharSequence)queryWrapper.getSqlSelect())) {
            selectBuilder.append("*");
        }
        if (!(aliasNames = this.ref.findAlias()).isEmpty()) {
            for (String aliasName : aliasNames) {
                DBAlias found = this.ref.findAlias(aliasName);
                Class entityCls = this.ref.seekType(found.table());
                String tableAlias = this.ref.seekAlias(entityCls);
                DBNode meta = this.ref.findBy(entityCls);
                String column = meta.vColumn(found.name());
                selectBuilder.append(",").append(tableAlias).append(".").append(column).append(" AS ").append(aliasName);
            }
            Kv kv = this.ref.mapIdAlias();
            selectBuilder.append(",").append((String)kv.key()).append(".").append((String)kv.value()).append(" AS ").append((String)kv.value());
            log.info("[ R2MO ] SELECT \u8bed\u53e5\u90e8\u5206 = {}", (Object)selectBuilder);
        }
        queryWrapper.select(new String[]{selectBuilder.toString()});
    }
}

