/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.dbe.mybatisplus.spi;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import io.r2mo.base.dbe.constant.QCV;
import io.r2mo.base.dbe.operation.OpAggr;
import io.r2mo.base.dbe.syntax.QTree;
import io.r2mo.dbe.common.operation.AbstractDbOperation;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class OpAggrImpl<T, M extends BaseMapper<T>>
extends AbstractDbOperation<QueryWrapper<T>, T, M>
implements OpAggr {
    OpAggrImpl(Class<T> entityCls, M mapper) {
        super(entityCls, mapper);
    }

    public <N extends Number> Optional<N> execute(String aggrField, Class<N> returnCls, QCV.Aggr aggr, String field, Object value) {
        QueryWrapper query = (QueryWrapper)this.analyzer().where(field, value);
        return this.execute(aggrField, returnCls, query, aggr);
    }

    public <N extends Number> Optional<N> execute(String aggrField, Class<N> returnCls, QCV.Aggr aggr, QTree criteria) {
        QueryWrapper query = (QueryWrapper)this.analyzer().where(criteria);
        return this.execute(aggrField, returnCls, query, aggr);
    }

    public <N extends Number> Optional<N> execute(String aggrField, Class<N> returnCls, QCV.Aggr aggr, Map<String, Object> map) {
        QueryWrapper query = (QueryWrapper)this.analyzer().where(map);
        return this.execute(aggrField, returnCls, query, aggr);
    }

    public <N extends Number> ConcurrentMap<String, N> execute(String aggrField, Class<N> returnCls, QCV.Aggr aggr, String field, Object value, String groupBy) {
        QueryWrapper query = (QueryWrapper)this.analyzer().where(field, value);
        return this.executeGrouped(aggrField, returnCls, aggr, query, groupBy);
    }

    public <N extends Number> ConcurrentMap<String, N> execute(String aggrField, Class<N> returnCls, QCV.Aggr aggr, QTree criteria, String groupBy) {
        QueryWrapper query = (QueryWrapper)this.analyzer().where(criteria);
        return this.executeGrouped(aggrField, returnCls, aggr, query, groupBy);
    }

    public <N extends Number> ConcurrentMap<String, N> execute(String aggrField, Class<N> returnCls, QCV.Aggr aggr, Map<String, Object> map, String groupBy) {
        QueryWrapper query = (QueryWrapper)this.analyzer().where(map);
        return this.executeGrouped(aggrField, returnCls, aggr, query, groupBy);
    }

    private <N extends Number> ConcurrentMap<String, N> executeGrouped(String aggrField, Class<N> returnCls, QCV.Aggr aggr, QueryWrapper<T> query, String groupBy) {
        Objects.requireNonNull(aggr, "[ R2MO ] \u805a\u96c6\u51fd\u6570 aggr \u4e0d\u80fd\u4e3a\u7a7a");
        Objects.requireNonNull(groupBy, "[ R2MO ] \u5206\u7ec4\u5b57\u6bb5 groupBy \u4e0d\u80fd\u4e3a\u7a7a");
        String alias = "__agg__";
        String aggrSelect = QCV.Aggr.COUNT == aggr ? "COUNT(*) AS __agg__" : this.buildAggr(Objects.requireNonNull(aggrField, "[ R2MO ] \u975e COUNT \u805a\u96c6\u65f6\uff0c\u805a\u96c6\u5b57\u6bb5 aggrField \u4e0d\u80fd\u4e3a\u7a7a"), aggr) + " AS __agg__";
        ((QueryWrapper)query.select((Object[])new String[]{groupBy, aggrSelect})).groupBy((Object)groupBy);
        List rows = ((BaseMapper)this.executor()).selectMaps(query);
        ConcurrentHashMap result = new ConcurrentHashMap(Math.max(16, rows.size() * 2));
        for (Map row : rows) {
            if (row == null || row.isEmpty()) continue;
            Object g = row.get(groupBy);
            if (g == null) {
                g = row.entrySet().stream().filter(e -> e.getKey() != null && ((String)e.getKey()).equalsIgnoreCase(groupBy)).map(Map.Entry::getValue).findFirst().orElse(null);
            }
            Object v = row.getOrDefault("__agg__", row.get("__agg__".toUpperCase()));
            if (g == null || v == null) continue;
            Optional<N> casted = this.buildResult(v, returnCls);
            Object finalG = g;
            casted.ifPresent(n -> result.put(String.valueOf(finalG), n));
        }
        return result;
    }

    private <N extends Number> Optional<N> execute(String aggrField, Class<N> returnCls, QueryWrapper<T> query, QCV.Aggr aggr) {
        if (Objects.isNull(aggr)) {
            return Optional.empty();
        }
        if (QCV.Aggr.COUNT == aggr) {
            return this.buildResult(((BaseMapper)this.executor()).selectCount(query), returnCls);
        }
        Objects.requireNonNull(aggrField);
        String fieldSelect = this.buildAggr(aggrField, aggr);
        query.select((Object[])new String[]{fieldSelect});
        List retultList = ((BaseMapper)this.executor()).selectObjs(query);
        if (retultList.isEmpty()) {
            return Optional.empty();
        }
        Object ret = retultList.get(0);
        return this.buildResult(ret, returnCls);
    }

    private <N extends Number> Optional<N> buildResult(Object ret, Class<N> targetClass) {
        if (Objects.isNull(ret)) {
            return Optional.empty();
        }
        if (ret instanceof Long) {
            Long retLong = (Long)ret;
            if (Long.class == targetClass) {
                return Optional.of(retLong);
            }
        }
        String str = ret.toString();
        Number retN = targetClass == Byte.class || targetClass == Byte.TYPE ? (Number)Byte.valueOf(str) : (Number)(targetClass == Short.class || targetClass == Short.TYPE ? (Number)Short.valueOf(str) : (Number)(targetClass == Integer.class || targetClass == Integer.TYPE ? (Number)Integer.valueOf(str) : (Number)(targetClass == Long.class || targetClass == Long.TYPE ? (Number)Long.valueOf(str) : (Number)(targetClass == Float.class || targetClass == Float.TYPE ? (Number)Float.valueOf(str) : (Number)(targetClass == Double.class || targetClass == Double.TYPE ? (Number)Double.valueOf(str) : (Number)(targetClass == BigDecimal.class ? new BigDecimal(str) : (targetClass == BigInteger.class ? new BigInteger(str) : null)))))));
        return Optional.ofNullable(retN);
    }

    private String buildAggr(String fieldAggr, QCV.Aggr aggr) {
        return switch (aggr) {
            default -> throw new IncompatibleClassChangeError();
            case QCV.Aggr.COUNT -> "COUNT(" + fieldAggr + ")";
            case QCV.Aggr.SUM -> "SUM(" + fieldAggr + ")";
            case QCV.Aggr.AVG -> "AVG(" + fieldAggr + ")";
            case QCV.Aggr.MAX -> "MAX(" + fieldAggr + ")";
            case QCV.Aggr.MIN -> "MIN(" + fieldAggr + ")";
        };
    }
}

