/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.dbe.mybatisplus.spi;

import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.conditions.query.Query;
import io.r2mo.base.dbe.constant.QOp;
import io.r2mo.base.dbe.syntax.QBranch;
import io.r2mo.base.dbe.syntax.QLeaf;
import io.r2mo.base.dbe.syntax.QNode;
import io.r2mo.base.dbe.syntax.QProjection;
import io.r2mo.base.dbe.syntax.QSorter;
import io.r2mo.spi.SPI;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MetaFix {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetaFix.class);

    MetaFix() {
    }

    static Collection<?> toCollection(Object value) {
        if (value instanceof Collection) {
            return (Collection)value;
        }
        return SPI.V_UTIL.toCollection(value);
    }

    static <T, Q extends Query<Q, T, String>> void filterBy(Q query, QProjection fields, Function<String, String> columnFn) {
        List fieldList;
        if (fields.isOk() && !(fieldList = fields.item()).isEmpty()) {
            List<String> columnList = fieldList.stream().map(columnFn).filter(Objects::nonNull).toList();
            query.select(columnList);
        }
    }

    static <T, Q extends AbstractWrapper<T, String, Q>> void orderBy(Q query, QSorter sorter, Function<String, String> columnFn) {
        if (Objects.isNull(sorter)) {
            return;
        }
        sorter.item().forEach(kv -> {
            boolean isAsc = (Boolean)kv.value();
            String field = (String)kv.key();
            String column = (String)columnFn.apply(field);
            if (isAsc) {
                query.orderByAsc((Object)column);
            } else {
                query.orderByDesc((Object)column);
            }
        });
    }

    static <T, Q extends AbstractWrapper<T, String, Q>> void whereTree(QNode node, Q query, Function<QLeaf, String> columnFn) {
        if (node instanceof QBranch) {
            QBranch branch = (QBranch)node;
            MetaFix.whereBranch(branch, query, columnFn);
        } else if (node instanceof QLeaf) {
            QLeaf leaf = (QLeaf)node;
            MetaFix.whereLeaf(leaf, query, columnFn);
        }
    }

    private static <T, Q extends AbstractWrapper<T, String, Q>> void whereBranch(QBranch branch, Q query, Function<QLeaf, String> columnFn) {
        Set nodes = branch.nodes();
        QOp op = branch.op();
        nodes.forEach(node -> {
            if (QOp.AND == op) {
                query.and(w -> MetaFix.whereTree(node, w, columnFn));
            } else {
                query.or(w -> MetaFix.whereTree(node, w, columnFn));
            }
        });
    }

    static <T, Q extends AbstractWrapper<T, String, Q>> void whereLeaf(QLeaf leaf, Q query, Function<QLeaf, String> columnFn) {
        String column = columnFn.apply(leaf);
        switch (leaf.op()) {
            case EQ: {
                query.eq((Object)column, leaf.value());
                break;
            }
            case NEQ: {
                query.ne((Object)column, leaf.value());
                break;
            }
            case GT: {
                query.gt((Object)column, leaf.value());
                break;
            }
            case GTE: {
                query.ge((Object)column, leaf.value());
                break;
            }
            case LT: {
                query.lt((Object)column, leaf.value());
                break;
            }
            case LTE: {
                query.le((Object)column, leaf.value());
                break;
            }
            case CONTAIN: {
                query.like((Object)column, leaf.value());
                break;
            }
            case START: {
                query.likeRight((Object)column, leaf.value());
                break;
            }
            case END: {
                query.likeLeft((Object)column, leaf.value());
                break;
            }
            case IN: {
                query.in((Object)column, MetaFix.toCollection(leaf.value()));
                break;
            }
            case NOT_IN: {
                query.notIn((Object)column, new Object[]{leaf.value()});
                break;
            }
            case NULL: {
                query.isNull((Object)column);
                break;
            }
            case NOT_NULL: {
                query.isNotNull((Object)column);
            }
        }
    }
}

