/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.dbe.mybatisplus;

import com.github.yulichang.base.MPJBaseMapper;
import com.github.yulichang.query.MPJQueryWrapper;
import io.r2mo.base.dbe.Join;
import io.r2mo.base.dbe.common.DBLoad;
import io.r2mo.base.dbe.common.DBNode;
import io.r2mo.base.dbe.common.DBRef;
import io.r2mo.base.dbe.operation.OpJoin;
import io.r2mo.base.dbe.operation.QrAnalyzer;
import io.r2mo.dbe.common.DBEJ;
import io.r2mo.dbe.mybatisplus.JoinProxy;
import io.r2mo.dbe.mybatisplus.spi.OpJoinImpl;
import io.r2mo.dbe.mybatisplus.spi.QrAnalyzerJoin;
import io.r2mo.spi.SPI;
import io.r2mo.typed.cc.Cc;
import io.r2mo.typed.common.Kv;

public class DBJ<T>
extends DBEJ<MPJQueryWrapper<T>, T, MPJBaseMapper<T>> {
    private final QrAnalyzer<MPJQueryWrapper<T>> analyzer;
    private static final Cc<String, DBJ<?>> CCT_DBE = Cc.openThread();
    private final JoinProxy<T> joinProxy;

    private DBJ(DBRef ref, JoinProxy<T> executor) {
        super(ref, executor.mapper());
        this.joinProxy = executor;
        this.analyzer = new QrAnalyzerJoin(ref);
        this.afterConstruct();
    }

    protected void afterConstruct() {
        OpJoin opJoin = this.opJoin;
        if (opJoin instanceof OpJoinImpl) {
            OpJoinImpl joinAction = (OpJoinImpl)opJoin;
            joinAction.afterConstruct(this.joinProxy);
        }
    }

    protected QrAnalyzer<MPJQueryWrapper<T>> analyzer() {
        return this.analyzer;
    }

    public DBJ<T> alias(String table, String field, String alias) {
        this.ref.alias(table, field, alias);
        return this;
    }

    public DBJ<T> alias(Class<?> entityCls, String field, String alias) {
        DBNode found = this.ref.findBy(entityCls);
        return this.alias(found.table(), field, alias);
    }

    public static <T> DBJ<T> of(Join meta, JoinProxy<T> baseMapper) {
        DBLoad loader = SPI.SPI_DB.loader();
        DBNode leftNode = loader.configure(meta.from(), meta.vFrom());
        DBNode rightNode = loader.configure(meta.to(), meta.vTo());
        Kv kvJoin = Kv.create((Object)meta.fromField(), (Object)meta.toField());
        return DBJ.of(DBRef.of((DBNode)leftNode, (DBNode)rightNode, (Kv)kvJoin), baseMapper);
    }

    public static <T> DBJ<T> of(DBRef ref, JoinProxy<T> mapper) {
        String cacheKey = ref.hashCode() + "@" + mapper.hashCode();
        return (DBJ)((Object)CCT_DBE.pick(() -> new DBJ(ref, mapper), (Object)cacheKey));
    }
}

