/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.dbe.mybatisplus.spi;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.r2mo.base.dbe.constant.QOp;
import io.r2mo.base.dbe.operation.QrAnalyzer;
import io.r2mo.base.dbe.syntax.QBranch;
import io.r2mo.base.dbe.syntax.QLeaf;
import io.r2mo.base.dbe.syntax.QNode;
import io.r2mo.base.dbe.syntax.QPager;
import io.r2mo.base.dbe.syntax.QProjection;
import io.r2mo.base.dbe.syntax.QQuery;
import io.r2mo.base.dbe.syntax.QSorter;
import io.r2mo.base.dbe.syntax.QTree;
import io.r2mo.dbe.mybatisplus.spi.MetaTable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

class QrAnalyzerImpl<T>
implements QrAnalyzer<QueryWrapper<T>> {
    private final Class<T> entityCls;
    private final MetaTable<T> meta;

    QrAnalyzerImpl(Class<T> entityCls) {
        this.entityCls = entityCls;
        this.meta = MetaTable.of(entityCls);
    }

    public QueryWrapper<T> whereIn(String field, Object ... values) {
        String column = this.meta.vColumn(field);
        return (QueryWrapper)Wrappers.query(this.entityCls).in((Object)column, Arrays.asList(values));
    }

    public QueryWrapper<T> where(String field, Object value) {
        String column = this.meta.vColumn(field);
        return (QueryWrapper)Wrappers.query(this.entityCls).eq((Object)column, value);
    }

    public QueryWrapper<T> where(Map<String, Object> condition) {
        Map<String, Object> column = this.meta.vColumn(condition);
        return (QueryWrapper)Wrappers.query(this.entityCls).allEq(column);
    }

    public QueryWrapper<T> where(QTree tree, QSorter sorter) {
        if (Objects.isNull(tree)) {
            return null;
        }
        QueryWrapper condition = Wrappers.query(this.entityCls);
        QNode root = tree.item();
        this.where(root, condition);
        this.meta.orderBy(condition, sorter);
        return condition;
    }

    public QueryWrapper<T> where(QQuery query) {
        List fieldList;
        Objects.requireNonNull(query);
        QueryWrapper<T> condition = this.where(query.criteria(), query.sorter());
        QProjection fields = query.projection();
        if (fields.isOk() && !(fieldList = fields.item()).isEmpty()) {
            List<String> columnList = this.meta.vColumn(fieldList);
            condition.select(columnList);
        }
        return condition;
    }

    private void where(QNode node, QueryWrapper<T> query) {
        if (node instanceof QBranch) {
            QBranch branch = (QBranch)node;
            this.whereInternal(branch, query);
        } else if (node instanceof QLeaf) {
            QLeaf leaf = (QLeaf)node;
            this.whereInternal(leaf, query);
        }
    }

    private void whereInternal(QBranch branch, QueryWrapper<T> query) {
        Set nodes = branch.nodes();
        QOp op = branch.op();
        nodes.forEach(node -> {
            if (QOp.AND == op) {
                query.and(w -> this.where((QNode)node, (QueryWrapper<T>)w));
            } else {
                query.or(w -> this.where((QNode)node, (QueryWrapper<T>)w));
            }
        });
    }

    private void whereInternal(QLeaf leaf, QueryWrapper<T> query) {
        QOp op = leaf.op();
        String column = this.meta.vColumn(leaf.field());
        switch (op) {
            case EQ: {
                query.eq((Object)column, leaf.value());
                break;
            }
            case NEQ: {
                query.ne((Object)column, leaf.value());
                break;
            }
            case GT: {
                query.gt((Object)column, leaf.value());
                break;
            }
            case GTE: {
                query.ge((Object)column, leaf.value());
                break;
            }
            case LT: {
                query.lt((Object)column, leaf.value());
                break;
            }
            case LTE: {
                query.le((Object)column, leaf.value());
                break;
            }
            case CONTAIN: {
                query.like((Object)column, leaf.value());
                break;
            }
            case START: {
                query.likeRight((Object)column, leaf.value());
                break;
            }
            case END: {
                query.likeLeft((Object)column, leaf.value());
                break;
            }
            case IN: {
                this.meta.in(leaf, query);
                break;
            }
            case NOT_IN: {
                query.notIn((Object)column, new Object[]{leaf.value()});
                break;
            }
            case NULL: {
                query.isNull((Object)column);
                break;
            }
            case NOT_NULL: {
                query.isNotNull((Object)column);
            }
        }
    }

    public IPage<T> page(QQuery query) {
        if (Objects.isNull(query)) {
            return null;
        }
        QPager pager = query.pager();
        if (Objects.isNull(pager)) {
            return null;
        }
        return new Page((long)pager.getPage(), (long)pager.getSize());
    }
}

