/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.dbe.mybatisplus.spi;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.r2mo.base.dbe.constant.QOp;
import io.r2mo.base.dbe.operation.QrAnalyzer;
import io.r2mo.base.dbe.syntax.QBranch;
import io.r2mo.base.dbe.syntax.QLeaf;
import io.r2mo.base.dbe.syntax.QNode;
import io.r2mo.base.dbe.syntax.QPager;
import io.r2mo.base.dbe.syntax.QProjection;
import io.r2mo.base.dbe.syntax.QQuery;
import io.r2mo.base.dbe.syntax.QSorter;
import io.r2mo.base.dbe.syntax.QTree;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

class QrAnalyzerImpl<T>
implements QrAnalyzer<QueryWrapper<T>> {
    private final Class<T> entityCls;

    QrAnalyzerImpl(Class<T> entityCls) {
        this.entityCls = entityCls;
    }

    public QueryWrapper<T> whereIn(String field, Object ... values) {
        return (QueryWrapper)Wrappers.query(this.entityCls).in((Object)field, Arrays.asList(values));
    }

    public QueryWrapper<T> where(String field, Object value) {
        return (QueryWrapper)Wrappers.query(this.entityCls).eq((Object)field, value);
    }

    public QueryWrapper<T> where(Map<String, Object> condition) {
        return (QueryWrapper)Wrappers.query(this.entityCls).allEq(condition);
    }

    public QueryWrapper<T> where(QTree tree, QSorter sorter) {
        if (Objects.isNull(tree)) {
            return null;
        }
        QueryWrapper condition = Wrappers.query(this.entityCls);
        QNode root = tree.item();
        this.where(root, condition);
        this.orderBy(condition, sorter);
        return condition;
    }

    public QueryWrapper<T> where(QQuery query) {
        List columnList;
        Objects.requireNonNull(query);
        QueryWrapper<T> condition = this.where(query.criteria(), query.sorter());
        QProjection columns = query.projection();
        if (columns.isOk() && !(columnList = columns.item()).isEmpty()) {
            condition.select(columnList);
        }
        return null;
    }

    private void where(QNode node, QueryWrapper<T> query) {
        if (node instanceof QBranch) {
            QBranch branch = (QBranch)node;
            this.whereInternal(branch, query);
        } else if (node instanceof QLeaf) {
            QLeaf leaf = (QLeaf)node;
            this.whereInternal(leaf, query);
        }
    }

    private void whereInternal(QBranch branch, QueryWrapper<T> query) {
        Set nodes = branch.nodes();
        QOp op = branch.op();
        nodes.forEach(node -> {
            if (QOp.AND == op) {
                query.and(w -> this.where((QNode)node, (QueryWrapper<T>)w));
            } else {
                query.or(w -> this.where((QNode)node, (QueryWrapper<T>)w));
            }
        });
    }

    private void whereInternal(QLeaf leaf, QueryWrapper<T> query) {
        QOp op = leaf.op();
        switch (op) {
            case EQ: {
                query.eq((Object)leaf.field(), leaf.value());
                break;
            }
            case NEQ: {
                query.ne((Object)leaf.field(), leaf.value());
                break;
            }
            case GT: {
                query.gt((Object)leaf.field(), leaf.value());
                break;
            }
            case GTE: {
                query.ge((Object)leaf.field(), leaf.value());
                break;
            }
            case LT: {
                query.lt((Object)leaf.field(), leaf.value());
                break;
            }
            case LTE: {
                query.le((Object)leaf.field(), leaf.value());
                break;
            }
            case CONTAIN: {
                query.like((Object)leaf.field(), leaf.value());
                break;
            }
            case START: {
                query.likeRight((Object)leaf.field(), leaf.value());
                break;
            }
            case END: {
                query.likeLeft((Object)leaf.field(), leaf.value());
                break;
            }
            case IN: {
                query.in((Object)leaf.field(), new Object[]{leaf.value()});
                break;
            }
            case NOT_IN: {
                query.notIn((Object)leaf.field(), new Object[]{leaf.value()});
                break;
            }
            case NULL: {
                query.isNull((Object)leaf.field());
                break;
            }
            case NOT_NULL: {
                query.isNotNull((Object)leaf.field());
            }
        }
    }

    private void orderBy(QueryWrapper<T> query, QSorter sorter) {
        if (Objects.isNull(sorter)) {
            return;
        }
        sorter.item().forEach(kv -> {
            boolean isAsc = (Boolean)kv.value();
            String field = (String)kv.key();
            if (isAsc) {
                query.orderByAsc((Object)field);
            } else {
                query.orderByDesc((Object)field);
            }
        });
    }

    public IPage<T> page(QQuery query) {
        if (Objects.isNull(query)) {
            return null;
        }
        QPager pager = query.pager();
        if (Objects.isNull(pager)) {
            return null;
        }
        return new Page((long)pager.getPage(), (long)pager.getSize());
    }
}

