/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.dbe.mybatisplus.generator;

import io.r2mo.dbe.mybatisplus.generator.GenConfig;
import io.r2mo.dbe.mybatisplus.generator.GenProcessor;
import io.r2mo.dbe.mybatisplus.generator.GenProcessorMapper;
import io.r2mo.dbe.mybatisplus.generator.GenProcessorMapperXml;
import io.r2mo.dbe.mybatisplus.generator.GenProcessorService;
import io.r2mo.dbe.mybatisplus.generator.GenProcessorServiceImpl;
import io.r2mo.dbe.mybatisplus.generator.GenProcessorSql;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SourceGenerator.class);
    private final GenProcessor processorSql = new GenProcessorSql();
    private final GenProcessor processorMapper = new GenProcessorMapper();
    private final GenProcessor processorXml = new GenProcessorMapperXml();
    private final GenProcessor processorService = new GenProcessorService();
    private final GenProcessor processorServiceImpl = new GenProcessorServiceImpl();
    private GenConfig genConfig;

    public SourceGenerator(Class<? extends GenConfig> clazz) {
        try {
            this.genConfig = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            this.genConfig = null;
        }
    }

    public void generate() {
        this.generate(true);
    }

    public void generate(boolean isFull) {
        this.purgeSql();
        List<Class<?>> entities = this.genConfig.getEntities();
        for (Class<?> entity : entities) {
            this.processorSql.generate(entity, this.genConfig);
            if (!isFull) continue;
            this.processorMapper.generate(entity, this.genConfig);
            this.processorXml.generate(entity, this.genConfig);
            this.processorService.generate(entity, this.genConfig);
            this.processorServiceImpl.generate(entity, this.genConfig);
        }
    }

    private void purgeSql() {
        Path pathDB = this.genConfig.outSql();
        Path pathSchema = pathDB.resolve("schema");
        Path v1_init_schema = pathSchema.resolve("V1__init_schema.sql");
        try {
            if (Files.exists(v1_init_schema, new LinkOption[0])) {
                Files.delete(v1_init_schema);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

